/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

A separable rank filter.


Medians aren't separable, but if you want a large robust smoother to
be relatively quick then it is worthwhile pretending that they are.

This code was contributed in the Insight Journal paper: "Efficient
implementation of kernel filtering" by Beare R., Lehmann G https://doi.org/10.54294/igq8fn


Richard Beare

See:
 itk::simple::FastApproximateRank for the procedural interface

 itk::FastApproximateRankImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFastApproximateRankImageFilter.h
*/
public class FastApproximateRankImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FastApproximateRankImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FastApproximateRankImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FastApproximateRankImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FastApproximateRankImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FastApproximateRankImageFilter::~FastApproximateRankImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FastApproximateRankImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FastApproximateRankImageFilter::FastApproximateRankImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FastApproximateRankImageFilter() {
    this(SimpleITKJNI.new_FastApproximateRankImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FastApproximateRankImageFilter::SetRank(double Rank)
*/
public  void setRank(double Rank) {
    SimpleITKJNI.FastApproximateRankImageFilter_setRank(swigCPtr, this, Rank);
  }

  /**
double itk::simple::FastApproximateRankImageFilter::GetRank() const
*/
public  double getRank() {
    return SimpleITKJNI.FastApproximateRankImageFilter_getRank(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastApproximateRankImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.FastApproximateRankImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::FastApproximateRankImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.FastApproximateRankImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::FastApproximateRankImageFilter::GetRadius() const
*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.FastApproximateRankImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
std::string itk::simple::FastApproximateRankImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FastApproximateRankImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FastApproximateRankImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FastApproximateRankImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FastApproximateRankImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FastApproximateRankImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
