/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Binarize an input image using double thresholding.


Double threshold addresses the difficulty in selecting a threshold
that will select the objects of interest without selecting extraneous
objects. Double threshold considers two threshold ranges: a narrow
range and a wide range (where the wide range encompasses the narrow
range). If the wide range was used for a traditional threshold (where
values inside the range map to the foreground and values outside the
range map to the background), many extraneous pixels may survive the
threshold operation. If the narrow range was used for a traditional
threshold, then too few pixels may survive the threshold.

Double threshold uses the narrow threshold image as a marker image and
the wide threshold image as a mask image in the geodesic dilation.
Essentially, the marker image (narrow threshold) is dilated but
constrained to lie within the mask image (wide threshold). Thus, only
the objects of interest (those pixels that survived the narrow
threshold) are extracted but the those objects appear in the final
image as they would have if the wide threshold was used.


See:
 GrayscaleGeodesicDilateImageFilter

 MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleFunctionDilateImageFilter , BinaryDilateImageFilter

 itk::simple::DoubleThreshold for the procedural interface

 itk::DoubleThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkDoubleThresholdImageFilter.h
*/
public class DoubleThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected DoubleThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.DoubleThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DoubleThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(DoubleThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::DoubleThresholdImageFilter::~DoubleThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_DoubleThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::DoubleThresholdImageFilter::DoubleThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  DoubleThresholdImageFilter() {
    this(SimpleITKJNI.new_DoubleThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetThreshold1(double Threshold1)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits&lt;InputPixelType&gt;::NonpositiveMin() . The two upper thresholds default NumericTraits&lt;InputPixelType&gt;::max . Threshold1 &lt;= Threshold2 &lt;= Threshold3 &lt;= Threshold4.

*/
public  void setThreshold1(double Threshold1) {
    SimpleITKJNI.DoubleThresholdImageFilter_setThreshold1(swigCPtr, this, Threshold1);
  }

  /**
double itk::simple::DoubleThresholdImageFilter::GetThreshold1() const

Get the threshold values.

*/
public  double getThreshold1() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getThreshold1(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetThreshold2(double Threshold2)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits&lt;InputPixelType&gt;::NonpositiveMin() . The two upper thresholds default NumericTraits&lt;InputPixelType&gt;::max . Threshold1 &lt;= Threshold2 &lt;= Threshold3 &lt;= Threshold4.

*/
public  void setThreshold2(double Threshold2) {
    SimpleITKJNI.DoubleThresholdImageFilter_setThreshold2(swigCPtr, this, Threshold2);
  }

  /**
double itk::simple::DoubleThresholdImageFilter::GetThreshold2() const

Get the threshold values.

*/
public  double getThreshold2() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getThreshold2(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetThreshold3(double Threshold3)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits&lt;InputPixelType&gt;::NonpositiveMin() . The two upper thresholds default NumericTraits&lt;InputPixelType&gt;::max . Threshold1 &lt;= Threshold2 &lt;= Threshold3 &lt;= Threshold4.

*/
public  void setThreshold3(double Threshold3) {
    SimpleITKJNI.DoubleThresholdImageFilter_setThreshold3(swigCPtr, this, Threshold3);
  }

  /**
double itk::simple::DoubleThresholdImageFilter::GetThreshold3() const

Get the threshold values.

*/
public  double getThreshold3() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getThreshold3(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetThreshold4(double Threshold4)

Set the thresholds. Four thresholds should be specified. The two lower
thresholds default to NumericTraits&lt;InputPixelType&gt;::NonpositiveMin() . The two upper thresholds default NumericTraits&lt;InputPixelType&gt;::max . Threshold1 &lt;= Threshold2 &lt;= Threshold3 &lt;= Threshold4.

*/
public  void setThreshold4(double Threshold4) {
    SimpleITKJNI.DoubleThresholdImageFilter_setThreshold4(swigCPtr, this, Threshold4);
  }

  /**
double itk::simple::DoubleThresholdImageFilter::GetThreshold4() const

Get the threshold values.

*/
public  double getThreshold4() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getThreshold4(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the "inside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::max()

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.DoubleThresholdImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::DoubleThresholdImageFilter::GetInsideValue() const

Get the "inside" pixel value.

*/
public  short getInsideValue() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the "outside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::ZeroValue() .

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.DoubleThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::DoubleThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::SetFullyConnected(bool FullyConnected)

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  void setFullyConnected(boolean FullyConnected) {
    SimpleITKJNI.DoubleThresholdImageFilter_setFullyConnected(swigCPtr, this, FullyConnected);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::FullyConnectedOn()

Set the value of FullyConnected to true or false respectfully.

*/
public  void fullyConnectedOn() {
    SimpleITKJNI.DoubleThresholdImageFilter_fullyConnectedOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::DoubleThresholdImageFilter::FullyConnectedOff()
*/
public  void fullyConnectedOff() {
    SimpleITKJNI.DoubleThresholdImageFilter_fullyConnectedOff(swigCPtr, this);
  }

  /**
bool itk::simple::DoubleThresholdImageFilter::GetFullyConnected() const

Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.

*/
public  boolean getFullyConnected() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getFullyConnected(swigCPtr, this);
  }

  /**
std::string itk::simple::DoubleThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.DoubleThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::DoubleThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.DoubleThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::DoubleThresholdImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.DoubleThresholdImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
