#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-43EWb89vVxZLL2JiEVh7PT
key:                  trifecta-2.1.4-43EWb89vVxZLL2JiEVh7PT
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  5b8d8c6ec12557a6c0cc9325e650455b
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-43EWb89vVxZLL2JiEVh7PT
depends:
    ansi-terminal-1.0.2-J3CYMek3QCg8mQRiAxriIL array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.3-Cn74iEPHjBE4gTddOEs4zL
    blaze-html-0.9.2.0-8IcbtSkHIUfHCDWbXpuBlK
    blaze-markup-0.8.3.0-2usLFhWFUEO5RSBL2lTpW3 bytestring-0.11.5.3
    charset-0.3.12-CFLbRbplOayLJdF3liT0dS
    comonad-5.0.9-EXk5LrDY0VmCeVKhwMhNAm containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-4NSqWhdpA07EddsbWxJd9v
    ghc-prim-0.9.1 hashable-1.4.4.0-HayYj9uqgN4KUEsvzi6aVt
    indexed-traversable-0.1.4-92FdEpJkEfDIV3402POC6M
    lens-5.3-4eslcvGQhMj5JgydAUw2Le mtl-2.2.2
    parsers-0.12.12-56g1Nx5LuKy21C9ziCb1ow
    prettyprinter-1.7.1-7RzBp6WzYsKH449UzuuntO
    prettyprinter-ansi-terminal-1.1.3-LoL3RNOrI4LLVb0h5b4flD
    profunctors-5.6.3-3RJN4RwyYywEf8j0QOKtB
    reducers-3.12.5-AVm4SB9dWzLBmDr0S0cOLF transformers-0.5.6.2
    unordered-containers-0.2.20-2eRdi4Eno3wAApPXuoC33k
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

