#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 tree-diff
version:              0.3.0.1
visibility:           public
id:                   tree-diff-0.3.0.1-CMHJqgWuMco5Y6To9EDFmh
key:                  tree-diff-0.3.0.1-CMHJqgWuMco5Y6To9EDFmh
license:              GPL-2.0-or-later
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/tree-diff
synopsis:             Diffing of (expression) trees.
description:
    Common diff algorithm works on list structures:

    @
    diff :: Eq a => [a] -> [a] -> [Edit a]
    @

    This package works on trees.

    @
    treeDiff :: Eq a => Tree a -> Tree a -> Edit (EditTree a)
    @

    This package also provides a way to diff arbitrary ADTs,
    using @Generics@-derivable helpers.

    This package differs from <http://hackage.haskell.org/package/gdiff gdiff>,
    in a two ways: @tree-diff@ doesn'\''t have patch function,
    and the "edit-script" is a tree itself, which is useful for pretty-printing.

    @
    >>> prettyEditExpr $ ediff (Foo 42 [True, False] "old") (Foo 42 [False, False, True] "new")
    Foo
    \  {fooBool = [-True, +False, False, +True],
    \   fooInt = 42,
    \   fooString = -"old" +"new"}
    @

category:             Data, Testing
abi:                  2208526804a8df10ea36fd38c30c50ae
exposed:              True
exposed-modules:
    Data.TreeDiff Data.TreeDiff.Class Data.TreeDiff.Expr
    Data.TreeDiff.Golden Data.TreeDiff.List Data.TreeDiff.OMap
    Data.TreeDiff.Parser Data.TreeDiff.Pretty Data.TreeDiff.QuickCheck
    Data.TreeDiff.Tree

import-dirs:          /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/tree-diff-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tree-diff
hs-libraries:         HStree-diff-0.3.0.1-CMHJqgWuMco5Y6To9EDFmh
depends:
    QuickCheck-2.14.3-D49gE8yyhJR3GOudg4cIYs
    aeson-2.1.2.1-5BFfk7iI7w6HPWzhbIRzqn
    ansi-terminal-1.0.2-J3CYMek3QCg8mQRiAxriIL
    ansi-wl-pprint-1.0.2-KpHAIF3Yk544QmqCau1SQw base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp bytestring-0.11.5.3
    containers-0.6.7 deepseq-1.4.8.0
    hashable-1.4.4.0-HayYj9uqgN4KUEsvzi6aVt parsec-3.1.16.1
    parsers-0.12.12-56g1Nx5LuKy21C9ziCb1ow pretty-1.1.3.6
    primitive-0.9.0.0-AqOaxoERoHJDqDj73ogtnE
    scientific-0.3.7.0-KrMKCvnfUrQHIZNLkrXCwo
    semialign-1.3-BEOiTXTzJKR2MDDBEuAs8X
    strict-0.5-1ukr0oOInpx2LAYVU9yJcd
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C text-2.0.2
    these-1.2.1-20Hlg0lYi8lImMgJCQDtWK time-1.12.2
    unordered-containers-0.2.20-2eRdi4Eno3wAApPXuoC33k
    uuid-types-1.0.6-DbsRnLkGwuo7vKOpcIvQ2R
    vector-0.13.2.0-KVjnIHG2Fg91rA02TsgQOf

haddock-interfaces:   /usr/share/doc/haskell-tree-diff/html/tree-diff.haddock
haddock-html:         /usr/share/doc/haskell-tree-diff/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

