#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 servant-swagger
version:              1.2.1
visibility:           public
id:                   servant-swagger-1.2.1-L1cs1iwzJJ4FYHFa02lvyl
key:                  servant-swagger-1.2.1-L1cs1iwzJJ4FYHFa02lvyl
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  927bf7fb0c836a3f529b58b4ee2726fa
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/servant-swagger-1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2.1-L1cs1iwzJJ4FYHFa02lvyl
depends:
    QuickCheck-2.14.3-D49gE8yyhJR3GOudg4cIYs
    aeson-2.1.2.1-5BFfk7iI7w6HPWzhbIRzqn
    aeson-pretty-0.8.10-CwXo2PdeXuRCVi5BLDBjO7 base-4.17.2.1
    base-compat-0.12.3-H9qTMlLoDHsHlMi1O3x7Rp bytestring-0.11.5.3
    hspec-2.10.10-498WDVJ7oon8rdIid4eagq
    http-media-0.8.1.1-J7Lb9kLBMJXKWc5eDTJ7sA
    insert-ordered-containers-0.2.5.3-52N9qIEy3Ih8HSfC1nXonc
    lens-5.3-4eslcvGQhMj5JgydAUw2Le
    servant-0.20.2-I71H44CjuKC28vh67kdJNH
    singleton-bool-0.1.7-5nFeAbz5j1TCIszlGGVrkh
    swagger2-2.8.10-L8yOoWIPnPYLgcIBKgVhv4 text-2.0.2
    unordered-containers-0.2.20-2eRdi4Eno3wAApPXuoC33k

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

