#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 echo
version:              0.1.4
visibility:           public
id:                   echo-0.1.4-HrG6UGs9bUNIRHTRpjaAQ
key:                  echo-0.1.4-HrG6UGs9bUNIRHTRpjaAQ
license:              BSD-3-Clause
copyright:            (C) 2016-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Provisional
homepage:             https://github.com/RyanGlScott/echo
synopsis:
    A cross-platform, cross-console way to handle echoing terminal input

description:
    The @base@ library exposes the @hGetEcho@ and @hSetEcho@ functions
    for querying and setting echo status, but unfortunately, neither
    function works with MinTTY consoles on Windows. This is a serious
    issue, since @hGetEcho@ and @hSetEcho@ are often used to disable
    input echoing when a program prompts for a password, so many
    programs will reveal your password as you type it on MinTTY!

    This library provides an alternative interface which works
    with both MinTTY and other consoles. An example is included
    which demonstrates how one might prompt for a password using
    this library. To build it, make sure to configure with the
    @-fexample@ flag.

category:             System
abi:                  6f7183f2945aad55ae98e2ea0be60b41
exposed:              True
exposed-modules:      System.IO.Echo System.IO.Echo.Internal
import-dirs:          /usr/lib/ghc-9.4.8/site-local/echo-0.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/echo-0.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/echo-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-echo
hs-libraries:         HSecho-0.1.4-HrG6UGs9bUNIRHTRpjaAQ
depends:              base-4.17.2.1 process-1.6.18.0
haddock-interfaces:   /usr/share/doc/haskell-echo/html/echo.haddock
haddock-html:         /usr/share/doc/haskell-echo/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

