#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              0.71.1
visibility:           public
id:                   brick-0.71.1-GnL1oG8RUw1F2nYFRio9s8
key:                  brick-0.71.1-GnL1oG8RUw1F2nYFRio9s8
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  1bdec9af1be7a43aab89ba185a5f08b9
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Themes Brick.Types Brick.Util
    Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick0.71
hs-libraries:         HSbrick-0.71.1-GnL1oG8RUw1F2nYFRio9s8
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    config-ini-0.2.7.0-2HdGFo2mual98uNw3EsziP containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    data-clist-0.2-9aYYBdhgESK9LcahuMe1pA deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-I6FB5Nlk17hG16fxQzZSEb
    exceptions-0.10.5 filepath-1.4.2.2
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-EzF89dGDbSA30wmbOWCJaZ transformers-0.5.6.2
    unix-2.7.3 vector-0.13.2.0-KVjnIHG2Fg91rA02TsgQOf
    vty-5.39-22tEqt1sjKgAPOnPUBGBMl
    word-wrap-0.5-8Hu9CxItdrV9OiF09S9B3T

haddock-interfaces:   /usr/share/doc/haskell-brick0.71/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick0.71/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

