/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.util.Locale;
import java.util.Set;

class BackgroundBuilder
extends ShorthandBuilder {
    private static CSSValueSyntax lengthPercentage = new SyntaxParser().parseSyntax("<length-percentage>");
    private StyleValue bgimage;
    private StyleValue bgposition;
    private StyleValue bgsize;
    private StyleValue bgrepeat;
    private StyleValue bgattachment;
    private StyleValue bgclip;
    private StyleValue bgorigin;
    private boolean appended = false;

    BackgroundBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("background", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 8;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        stringBuilder.append(this.getShorthandName()).append(':');
        this.bgimage = this.getCSSValue("background-image");
        this.bgposition = this.computeMultipleSubproperty("background-image", "background-position");
        this.bgsize = this.computeMultipleSubproperty("background-image", "background-size");
        this.bgrepeat = this.computeMultipleSubproperty("background-image", "background-repeat");
        this.bgattachment = this.computeMultipleSubproperty("background-image", "background-attachment");
        this.bgclip = this.computeMultipleSubproperty("background-image", "background-clip");
        this.bgorigin = this.computeMultipleSubproperty("background-image", "background-origin");
        CSSValue.CssType cssType = this.bgimage.getCssValueType();
        if (cssType == CSSValue.CssType.LIST && ((ValueList)this.bgimage).isCommaSeparated()) {
            if (!this.appendLayeredBackground(stringBuilder, set, ((ValueList)this.bgimage).getLength())) {
                return 1;
            }
        } else {
            byte by = this.checkForInherit();
            if (by == 1) {
                stringBuilder.append("inherit");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            byte by2 = this.checkForRevert();
            if (by2 == 1) {
                stringBuilder.append("revert");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (by2 == 2) {
                return 1;
            }
            if (!this.appendBackgroundImage(stringBuilder, this.bgimage)) {
                return 1;
            }
            if (!this.appendSingleLayer(stringBuilder, set)) {
                return 1;
            }
            if (!this.appended) {
                stringBuilder.append("none");
            }
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }

    private StyleValue computeMultipleSubproperty(String string, String string2) {
        return this.getParentStyle().computeBoundProperty(string, string2, this.getCSSValue(string2));
    }

    private byte checkForInherit() {
        return this.checkForInherit(this.bgimage, this.bgposition, this.bgsize, this.bgrepeat, this.bgattachment, this.bgclip, this.bgorigin, this.getCSSValue("background-color"));
    }

    private byte checkForInherit(StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5, StyleValue styleValue6, StyleValue styleValue7, StyleValue styleValue8) {
        byte by = this.checkForInherit(styleValue, styleValue2, styleValue3, styleValue4, styleValue5, styleValue6, styleValue7);
        if (by == 2) {
            return 2;
        }
        if (this.isInherit(styleValue8) ? by == 0 : by == 1) {
            return 2;
        }
        return by;
    }

    private byte checkForInherit(StyleValue styleValue, StyleValue styleValue2, StyleValue styleValue3, StyleValue styleValue4, StyleValue styleValue5, StyleValue styleValue6, StyleValue styleValue7) {
        int n = 0;
        if (this.isInherit(styleValue)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue2)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue3)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue4)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue5)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue6)) {
            n = (byte)(n + 1);
        }
        if (this.isInherit(styleValue7)) {
            n = (byte)(n + 1);
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForInherit(int n, int n2) {
        if (n != n2) {
            return this.checkForInherit(((ValueList)this.bgimage).item(n), ((ValueList)this.bgposition).item(n), ((ValueList)this.bgsize).item(n), ((ValueList)this.bgrepeat).item(n), ((ValueList)this.bgattachment).item(n), ((ValueList)this.bgclip).item(n), ((ValueList)this.bgorigin).item(n));
        }
        return this.checkForInherit(((ValueList)this.bgimage).item(n), ((ValueList)this.bgposition).item(n), ((ValueList)this.bgsize).item(n), ((ValueList)this.bgrepeat).item(n), ((ValueList)this.bgattachment).item(n), ((ValueList)this.bgclip).item(n), ((ValueList)this.bgorigin).item(n), this.getCSSValue("background-color"));
    }

    private byte checkForRevert() {
        return this.checkForCssKeyword(CSSValue.Type.REVERT);
    }

    private byte checkForCssKeyword(CSSValue.Type type) {
        int n = 0;
        if (BackgroundBuilder.isCssValueOfType(type, this.bgposition)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.bgsize)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.bgrepeat)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.bgattachment)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.bgclip)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.bgorigin)) {
            n = (byte)(n + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, this.getCSSValue("background-color"))) {
            n = (byte)(n + 1);
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 7: {
                return 1;
            }
        }
        return 2;
    }

    private byte checkForRevert(int n, int n2) {
        return this.checkForCssKeyword(CSSValue.Type.REVERT, n, n2);
    }

    private byte checkForCssKeyword(CSSValue.Type type, int n, int n2) {
        int n3;
        int n4 = 0;
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgposition).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgsize).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgrepeat).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgattachment).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgclip).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (BackgroundBuilder.isCssValueOfType(type, ((ValueList)this.bgorigin).item(n))) {
            n4 = (byte)(n4 + 1);
        }
        if (n != n2) {
            n3 = 6;
        } else {
            n3 = 7;
            if (BackgroundBuilder.isCssValueOfType(type, this.getCSSValue("background-color"))) {
                n4 = (byte)(n4 + 1);
            }
        }
        if (n4 == 0) {
            return 0;
        }
        if (n4 == n3) {
            return 1;
        }
        return 2;
    }

    private static boolean isRevertValue(StyleValue styleValue) {
        return BackgroundBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue);
    }

    private void appendText(StringBuilder stringBuilder, String string) {
        if (this.appended) {
            stringBuilder.append(' ');
        } else {
            this.appended = true;
        }
        stringBuilder.append(string);
    }

    private boolean appendLayeredBackground(StringBuilder stringBuilder, Set<String> set, int n) {
        int n2 = n - 1;
        if (!this.appendLayer(stringBuilder, set, 0, n2)) {
            return false;
        }
        for (int i = 1; i <= n2; ++i) {
            this.appended = false;
            stringBuilder.append(',');
            if (this.appendLayer(stringBuilder, set, i, n2)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder stringBuilder, Set<String> set, int n, int n2) {
        StyleValue styleValue;
        StyleValue styleValue2;
        StyleValue styleValue3;
        byte by = this.checkForInherit(n, n2);
        if (by == 1) {
            this.appendText(stringBuilder, "inherit");
            return true;
        }
        if (by == 2) {
            return false;
        }
        by = this.checkForRevert(n, n2);
        if (by == 1) {
            this.appendText(stringBuilder, "revert");
            return true;
        }
        if (by == 2) {
            return false;
        }
        if (set.contains("background-image") && !this.appendBackgroundImage(stringBuilder, ((ValueList)this.bgimage).item(n))) {
            return false;
        }
        ValueList valueList = (ValueList)this.bgposition;
        StyleValue styleValue4 = set.contains("background-position") ? valueList.item(n) : null;
        if (!this.appendBackgroundPositionSize(stringBuilder, styleValue4, styleValue3 = set.contains("background-size") ? ((ValueList)this.bgsize).item(n) : null)) {
            return false;
        }
        if (set.contains("background-repeat") && !this.appendBackgroundRepeat(stringBuilder, ((ValueList)this.bgrepeat).item(n))) {
            return false;
        }
        if (set.contains("background-attachment") && !this.appendBackgroundAttachment(stringBuilder, (valueList = (ValueList)this.bgattachment).item(n))) {
            return false;
        }
        boolean bl = set.contains("background-clip");
        if ((set.contains("background-origin") || bl) && !this.appendBackgroundOriginClip(stringBuilder, styleValue2 = ((ValueList)this.bgorigin).item(n), styleValue = bl ? ((ValueList)this.bgclip).item(n) : null)) {
            return false;
        }
        if (set.contains("background-color") && n == n2 && !this.appendBackgroundColor(stringBuilder, this.getCSSValue("background-color"))) {
            return false;
        }
        int n3 = stringBuilder.length();
        if (n3 == 11 || stringBuilder.charAt(n3 - 1) == ',') {
            stringBuilder.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder stringBuilder, Set<String> set) {
        StyleValue styleValue;
        StyleValue styleValue2;
        StyleValue styleValue3;
        StyleValue styleValue4 = set.contains("background-position") ? this.valueOrFirstItem(this.bgposition) : null;
        if (!this.appendBackgroundPositionSize(stringBuilder, styleValue4, styleValue3 = set.contains("background-size") ? this.valueOrFirstItem(this.bgsize) : null)) {
            return false;
        }
        if (set.contains("background-repeat") && !this.appendBackgroundRepeat(stringBuilder, this.valueOrFirstItem(this.bgrepeat))) {
            return false;
        }
        if (set.contains("background-attachment") && !this.appendBackgroundAttachment(stringBuilder, this.valueOrFirstItem(this.bgattachment))) {
            return false;
        }
        boolean bl = set.contains("background-clip");
        if ((set.contains("background-origin") || bl) && !this.appendBackgroundOriginClip(stringBuilder, styleValue2 = this.valueOrFirstItem(this.bgorigin), styleValue = bl ? this.valueOrFirstItem(this.bgclip) : null)) {
            return false;
        }
        if (set.contains("background-color")) {
            styleValue2 = this.getCSSValue("background-color");
            if (styleValue2.getCssValueType() == CSSValue.CssType.LIST) {
                return false;
            }
            return this.appendBackgroundColor(stringBuilder, styleValue2);
        }
        return true;
    }

    private StyleValue valueOrFirstItem(StyleValue styleValue) {
        ValueList valueList;
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST && (valueList = (ValueList)styleValue).isCommaSeparated()) {
            return valueList.item(0);
        }
        return styleValue;
    }

    private boolean appendBackgroundImage(StringBuilder stringBuilder, StyleValue styleValue) {
        if (!BackgroundBuilder.isRevertValue(styleValue) && this.possibleBackgroundImage(styleValue)) {
            this.appended = this.appendImage(stringBuilder, this.appended, styleValue);
            return true;
        }
        return false;
    }

    private boolean possibleBackgroundImage(StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            TypedValue typedValue = (TypedValue)styleValue;
            CSSValue.Type type = typedValue.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                String string = typedValue.getStringValue();
                return "none".equalsIgnoreCase(string);
            }
            return BackgroundBuilder.isImagePrimitiveValue(typedValue);
        }
        return cssType == CSSValue.CssType.KEYWORD;
    }

    private boolean appendBackgroundPositionSize(StringBuilder stringBuilder, StyleValue styleValue, StyleValue styleValue2) {
        Object object;
        boolean bl = false;
        if (styleValue != null) {
            object = styleValue.getCssValueType();
            String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
            if (BackgroundBuilder.isRevertValue(styleValue)) {
                return false;
            }
            if (object == CSSValue.CssType.TYPED) {
                if ((styleValue.getPrimitiveType() != CSSValue.Type.IDENT || BackgroundBuilder.isUnknownIdentifier("background-position", styleValue)) && styleValue.matches(lengthPercentage) != CSSValueSyntax.Match.TRUE) {
                    return false;
                }
                this.appendText(stringBuilder, string);
                bl = true;
            } else if (object == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)styleValue;
                if (valueList.isCommaSeparated() || string.indexOf(92) != -1) {
                    return false;
                }
                if (!("0% 0%".equals(string) || "left top".equals(string) || "top left".equals(string))) {
                    if (valueList.getLength() != 2 || !"center".equalsIgnoreCase(valueList.item(1).getCssText())) {
                        this.appendText(stringBuilder, string);
                    } else {
                        this.appendText(stringBuilder, valueList.item(0).getCssText());
                    }
                    bl = true;
                }
            } else if (object == CSSValue.CssType.PROXY) {
                return false;
            }
        }
        if (styleValue2 != null) {
            if (BackgroundBuilder.isRevertValue(styleValue2) || BackgroundBuilder.isUnknownIdentifier("background-size", styleValue2) || styleValue2.getCssValueType() == CSSValue.CssType.PROXY) {
                return false;
            }
            object = styleValue2.getMinifiedCssText().toLowerCase(Locale.ROOT);
            if (!("auto".equals(object) || "auto auto".equals(object) || "initial".equals(object) || "unset".equals(object))) {
                if (!bl) {
                    if (styleValue == null) {
                        styleValue = this.getCSSValue("background-position");
                    }
                    this.appendText(stringBuilder, styleValue.getMinifiedCssText());
                }
                stringBuilder.append('/').append((String)object);
                bl = true;
            }
        }
        if (bl) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendBackgroundRepeat(StringBuilder stringBuilder, StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
        if (!BackgroundBuilder.isIdentOrKeyword(styleValue) || BackgroundBuilder.isRevertValue(styleValue) || string.indexOf(92) != -1) {
            return false;
        }
        if (cssType == CSSValue.CssType.TYPED) {
            if (!"repeat".equals(string)) {
                this.appendText(stringBuilder, string);
            }
        } else if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(string)) {
                if ("no-repeat no-repeat".equals(string)) {
                    this.appendText(stringBuilder, "no-repeat");
                } else if ("space space".equals(string)) {
                    this.appendText(stringBuilder, "space");
                } else if ("round round".equals(string)) {
                    this.appendText(stringBuilder, "round");
                } else if ("repeat no-repeat".equals(string)) {
                    this.appendText(stringBuilder, "repeat-x");
                } else if ("no-repeat repeat".equals(string)) {
                    this.appendText(stringBuilder, "repeat-y");
                } else {
                    this.appendText(stringBuilder, string);
                }
            }
        }
        return true;
    }

    private boolean appendBackgroundAttachment(StringBuilder stringBuilder, StyleValue styleValue) {
        if (BackgroundBuilder.isIdentOrKeyword(styleValue) && !BackgroundBuilder.isRevertValue(styleValue) && !BackgroundBuilder.isUnknownIdentifier("background-attachment", styleValue)) {
            String string = styleValue.getMinifiedCssText().toLowerCase(Locale.ROOT);
            if (!("scroll".equals(string) || "initial".equals(string) || "unset".equals(string))) {
                this.appendText(stringBuilder, string);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendBackgroundOriginClip(StringBuilder stringBuilder, StyleValue styleValue, StyleValue styleValue2) {
        String string;
        boolean bl;
        String string2;
        boolean bl2;
        block14: {
            block15: {
                block13: {
                    block11: {
                        block12: {
                            block10: {
                                if (styleValue2 != null) break block10;
                                bl2 = true;
                                string2 = "border-box";
                                break block11;
                            }
                            if (styleValue2.getCssValueType() != CSSValue.CssType.KEYWORD) break block12;
                            switch (styleValue2.getPrimitiveType()) {
                                case INITIAL: 
                                case UNSET: {
                                    bl2 = true;
                                    string2 = "border-box";
                                    break block11;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        string2 = styleValue2.getMinifiedCssText().toLowerCase(Locale.ROOT);
                        bl2 = "border-box".equals(string2);
                    }
                    if (styleValue != null) break block13;
                    bl = true;
                    string = "padding-box";
                    break block14;
                }
                if (styleValue.getCssValueType() != CSSValue.CssType.KEYWORD) break block15;
                switch (styleValue.getPrimitiveType()) {
                    case INITIAL: 
                    case UNSET: {
                        bl = true;
                        string = "padding-box";
                        break block14;
                    }
                    default: {
                        return false;
                    }
                }
            }
            string = styleValue.getMinifiedCssText().toLowerCase(Locale.ROOT);
            bl = "padding-box".equals(string);
        }
        if (!bl || !bl2) {
            if (BackgroundBuilder.getShorthandDatabase().isIdentifierValue("background-origin", string) && BackgroundBuilder.getShorthandDatabase().isIdentifierValue("background-clip", string2)) {
                this.appendText(stringBuilder, string);
                if (!string.equals(string2)) {
                    this.appendText(stringBuilder, string2);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean appendBackgroundColor(StringBuilder stringBuilder, StyleValue styleValue) {
        if (!BackgroundBuilder.isRevertValue(styleValue) && BackgroundBuilder.isValidColor(styleValue)) {
            String string;
            StringBuilder stringBuilder2 = new StringBuilder();
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder2);
            DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
            try {
                declarationFormattingContext.writeMinifiedValue((SimpleWriter)bufferSimpleWriter, "background-color", styleValue);
                string = stringBuilder2.toString().toLowerCase(Locale.ROOT);
            }
            catch (Exception exception) {
                string = styleValue.getMinifiedCssText().toLowerCase(Locale.ROOT);
            }
            if (!("transparent".equals(string) || "rgba(0,0,0,0)".equals(string) || "rgb(0 0 0/0)".equals(string) || "initial".equals(string) || "unset".equals(string))) {
                this.appendText(stringBuilder, string);
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isValidColor(CSSValue cSSValue) {
        CSSValue.CssType cssType = cSSValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            CSSTypedValue cSSTypedValue = (CSSTypedValue)cSSValue;
            CSSValue.Type type = cSSTypedValue.getPrimitiveType();
            if (type == CSSValue.Type.COLOR || type == CSSValue.Type.COLOR_MIX) {
                return true;
            }
            if (type == CSSValue.Type.IDENT) {
                String string = cSSTypedValue.getStringValue().toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(string);
            }
        } else {
            return cSSValue.getCssValueType() == CSSValue.CssType.KEYWORD;
        }
        return false;
    }
}

