/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.HTMLDocument;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnonymousStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatInlineStyle;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMComputedStyle;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CSSDOMImplementation
extends BaseCSSStyleSheetFactory
implements DOMImplementation {
    private static final long serialVersionUID = 1L;
    private boolean strictErrorChecking = true;
    private BaseDocumentCSSStyleSheet defStyleSheet = null;
    private BaseDocumentCSSStyleSheet defQStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaQStyleSheet = null;

    public CSSDOMImplementation() {
        this(EnumSet.noneOf(Parser.Flag.class));
    }

    public CSSDOMImplementation(EnumSet<Parser.Flag> enumSet) {
        super(enumSet);
    }

    public DOMDocument newDocument() {
        MyXMLDocument myXMLDocument = new MyXMLDocument(null);
        myXMLDocument.setStrictErrorChecking(this.strictErrorChecking);
        return myXMLDocument;
    }

    public HTMLDocument newHTMLDocument() {
        DocumentType documentType = this.createDocumentType("html", null, null);
        return (HTMLDocument)this.createDocument("http://www.w3.org/1999/xhtml", "html", documentType);
    }

    @Override
    public DOMDocument createDocument(String string, String string2, DocumentType documentType) throws DOMException {
        if (documentType != null && documentType.getParentNode() != null) {
            throw new DOMException(4, "Doctype already in use");
        }
        DOMDocument dOMDocument = CSSDOMImplementation.isHTMLDocument(string, string2, documentType) ? this.createHTMLDocument(documentType) : this.createXMLDocument(documentType);
        dOMDocument.setStrictErrorChecking(this.strictErrorChecking);
        if (string2 != null && string2.length() != 0) {
            DOMElement dOMElement = dOMDocument.createElementNS(string, string2);
            if (dOMElement.getPrefix() != null && string != null) {
                Attr attr = dOMDocument.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + dOMElement.getPrefix());
                attr.setValue(string);
                dOMElement.setAttributeNodeNS(attr);
            }
            dOMDocument.appendChild(dOMElement);
        }
        return dOMDocument;
    }

    protected DOMDocument createXMLDocument(DocumentType documentType) {
        return new MyXMLDocument(documentType);
    }

    protected HTMLDocument createHTMLDocument(DocumentType documentType) {
        return new MyHTMLDocument(documentType);
    }

    private static boolean isHTMLDocument(String string, String string2, DocumentType documentType) {
        if (documentType != null) {
            return "html".equalsIgnoreCase(documentType.getName());
        }
        if (string2 != null) {
            return "html".equalsIgnoreCase(string2);
        }
        return string == null || "http://www.w3.org/1999/xhtml".equals(string);
    }

    @Override
    public DocumentType createDocumentType(String string, String string2, String string3) throws DOMException {
        if (string == null) {
            throw new NullPointerException("Null DTD qName.");
        }
        if (!DOMDocument.isValidName(string)) {
            throw new DOMException(5, "Invalid qName: " + string);
        }
        return new DocumentTypeImpl(string, string2, string3);
    }

    @Override
    @Deprecated
    public Object getFeature(String string, String string2) {
        return null;
    }

    @Override
    public boolean hasFeature(String string, String string2) {
        return true;
    }

    protected boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    public void setStrictErrorChecking(boolean bl) {
        this.strictErrorChecking = bl;
    }

    @Override
    protected BaseDocumentCSSStyleSheet createDocumentStyleSheet(byte by) {
        return new MyDocumentCSSStyleSheet(null, by);
    }

    @Override
    protected BaseCSSStyleSheet createRuleStyleSheet(AbstractCSSRule abstractCSSRule, String string, MediaQueryList mediaQueryList) {
        return new MyCSSStyleSheet(string, null, mediaQueryList, abstractCSSRule, abstractCSSRule.getOrigin());
    }

    @Override
    protected BaseCSSStyleSheet createLinkedStyleSheet(Node node, String string, MediaQueryList mediaQueryList) {
        Node node2;
        NamedNodeMap namedNodeMap;
        if (string == null && node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("title")) != null) {
            string = node2.getNodeValue();
        }
        return new MyCSSStyleSheet(string, node, mediaQueryList, null, 8);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node) {
        MyAnonymousStyleDeclaration myAnonymousStyleDeclaration = new MyAnonymousStyleDeclaration(node);
        return myAnonymousStyleDeclaration;
    }

    @Override
    public BaseDocumentCSSStyleSheet getUserAgentStyleSheet(CSSDocument.ComplianceMode complianceMode) {
        if (complianceMode == CSSDocument.ComplianceMode.STRICT) {
            if (this.uaStyleSheet == null) {
                this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
            }
            return this.uaStyleSheet;
        }
        if (this.uaQStyleSheet == null) {
            this.uaQStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaQStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        this.uaStyleSheet = this.htmlDefaultSheet();
        this.uaQStyleSheet = this.htmlQuirksDefaultSheet();
        this.defStyleSheet = null;
        this.defQStyleSheet = null;
    }

    @Override
    protected BaseDocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode complianceMode) {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet = complianceMode == CSSDocument.ComplianceMode.STRICT ? this.defStyleSheet : this.defQStyleSheet;
        return baseDocumentCSSStyleSheet;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.STRICT).clone();
        this.defQStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.QUIRKS).clone();
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.getUserNormalStyleSheet();
        if (abstractCSSStyleSheet != null) {
            this.defStyleSheet.addStyleSheet(abstractCSSStyleSheet);
            this.defQStyleSheet.addStyleSheet(abstractCSSStyleSheet);
        }
    }

    @Override
    protected InlineStyle createInlineStyle(Node node) {
        InlineStyle inlineStyle = !this.hasCompatValueFlags() ? new MyInlineStyle(node) : new MyCompatInlineStyle(node);
        return inlineStyle;
    }

    class MyAnonymousStyleDeclaration
    extends AnonymousStyleDeclaration {
        private static final long serialVersionUID = 1L;

        MyAnonymousStyleDeclaration(Node node) {
            super(node);
        }

        private MyAnonymousStyleDeclaration(MyAnonymousStyleDeclaration myAnonymousStyleDeclaration) {
            super(myAnonymousStyleDeclaration);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public AnonymousStyleDeclaration clone() {
            MyAnonymousStyleDeclaration myAnonymousStyleDeclaration = new MyAnonymousStyleDeclaration(this);
            return myAnonymousStyleDeclaration;
        }
    }

    class MyCSSStyleSheet
    extends DOMCSSStyleSheet {
        private static final long serialVersionUID = 1L;

        MyCSSStyleSheet(String string, Node node, MediaQueryList mediaQueryList, AbstractCSSRule abstractCSSRule, byte by) {
            super(string, node, mediaQueryList, abstractCSSRule, by);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String string, Node node, MediaQueryList mediaQueryList, AbstractCSSRule abstractCSSRule, byte by) {
            return new MyCSSStyleSheet(string, node, mediaQueryList, abstractCSSRule, by);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        protected void setMedia(MediaQueryList mediaQueryList) throws DOMException {
            super.setMedia(mediaQueryList);
        }

        @Override
        protected void setTitle(String string) {
            super.setTitle(string);
        }
    }

    class MyCompatInlineStyle
    extends CompatInlineStyle {
        private static final long serialVersionUID = 1L;

        MyCompatInlineStyle(Node node) {
            this.setOwnerNode(node);
        }

        MyCompatInlineStyle(CompatInlineStyle compatInlineStyle) {
            super(compatInlineStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyCompatInlineStyle(this);
        }
    }

    class MyDOMComputedStyle
    extends DOMComputedStyle {
        private static final long serialVersionUID = 1L;

        MyDOMComputedStyle(BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet) {
            super(baseDocumentCSSStyleSheet);
        }

        private MyDOMComputedStyle(ComputedCSSStyle computedCSSStyle) {
            super(computedCSSStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        protected void setOwnerNode(CSSElement cSSElement) {
            super.setOwnerNode(cSSElement);
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMComputedStyle myDOMComputedStyle = new MyDOMComputedStyle(this);
            return myDOMComputedStyle;
        }
    }

    private class MyDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        private static final long serialVersionUID = 1L;

        MyDocumentCSSStyleSheet(String string, byte by) {
            super(string, by);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String string, byte by) {
            return new MyDocumentCSSStyleSheet(string, by);
        }

        @Override
        protected ComputedCSSStyle createComputedCSSStyle() {
            return new MyDOMComputedStyle(this);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyHTMLDocument
    extends HTMLDocument {
        private static final long serialVersionUID = 1L;

        public MyHTMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL uRL) throws IOException {
            return uRL.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        private static final long serialVersionUID = 1L;

        MyInlineStyle(Node node) {
            this.setOwnerNode(node);
        }

        MyInlineStyle(InlineStyle inlineStyle) {
            super(inlineStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyInlineStyle(this);
        }
    }

    class MyXMLDocument
    extends DOMDocument {
        private static final long serialVersionUID = 1L;

        public MyXMLDocument(DocumentType documentType) {
            super(documentType);
        }

        @Override
        public CSSDOMImplementation getImplementation() {
            return CSSDOMImplementation.this;
        }

        @Override
        public URLConnection openConnection(URL uRL) throws IOException {
            return uRL.openConnection();
        }

        @Override
        protected CSSDOMImplementation getStyleSheetFactory() {
            return CSSDOMImplementation.this;
        }
    }
}

