/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSNumberValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.Evaluator;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.echosvg.i18n.LocalizableSupport;
import io.sf.carte.echosvg.parser.CalcParseException;
import io.sf.carte.echosvg.parser.DefaultErrorHandler;
import io.sf.carte.echosvg.parser.ErrorHandler;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.Parser;
import io.sf.carte.echosvg.util.io.NormalizingReader;
import io.sf.carte.echosvg.util.io.StreamNormalizingReader;
import io.sf.carte.echosvg.util.io.StringNormalizingReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractParser
implements Parser {
    public static final String BUNDLE_CLASSNAME = "io.sf.carte.echosvg.parser.resources.Messages";
    protected ErrorHandler errorHandler = new DefaultErrorHandler();
    protected LocalizableSupport localizableSupport = new LocalizableSupport("io.sf.carte.echosvg.parser.resources.Messages", AbstractParser.class.getClassLoader());
    protected NormalizingReader reader;
    protected int current;

    public int getCurrent() {
        return this.current;
    }

    public void setLocale(Locale locale) {
        this.localizableSupport.setLocale(locale);
    }

    public Locale getLocale() {
        return this.localizableSupport.getLocale();
    }

    public String formatMessage(String string, Object[] objectArray) throws MissingResourceException {
        return this.localizableSupport.formatMessage(string, objectArray);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void parse(Reader reader) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(reader);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    public void parse(InputStream inputStream, String string) throws ParseException {
        try {
            this.reader = new StreamNormalizingReader(inputStream, string);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
    }

    @Override
    public void parse(String string) throws ParseException {
        try {
            this.reader = new StringNormalizingReader(string);
            this.doParse();
        }
        catch (IOException iOException) {
            this.errorHandler.error(new ParseException(this.createErrorMessage("io.exception", null), iOException));
        }
        catch (CalcParseException calcParseException) {
            this.cssParse();
        }
    }

    void cssParse() throws ParseException {
        LexicalUnit lexicalUnit;
        PushbackReader pushbackReader = new PushbackReader((Reader)this.reader, 5);
        char[] cArray = new char[]{'c', 'a', 'l', 'c', '('};
        try {
            pushbackReader.unread(cArray);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue((Reader)pushbackReader);
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(12, cSSException.getMessage());
            dOMException.initCause(cSSException);
            ParseException parseException = new ParseException(dOMException);
            parseException.lineNumber = this.reader.getLine();
            parseException.columnNumber = this.reader.getColumn();
            this.errorHandler.error(parseException);
            return;
        }
        catch (IOException iOException) {
            throw new ParseException(iOException);
        }
        try {
            StyleValue styleValue = new ValueFactory().createCSSValue(lexicalUnit);
            this.handleStyleValue((CSSValue)styleValue);
        }
        catch (ParseException parseException) {
            parseException.lineNumber = this.reader.getLine();
            parseException.columnNumber = this.reader.getColumn();
            this.errorHandler.error(parseException);
        }
        catch (Exception exception) {
            ParseException parseException = new ParseException(exception);
            parseException.lineNumber = this.reader.getLine();
            parseException.columnNumber = this.reader.getColumn();
            this.errorHandler.error(parseException);
        }
        this.current = -1;
    }

    private void handleStyleValue(CSSValue cSSValue) throws ParseException {
        switch (cSSValue.getCssValueType()) {
            case LIST: {
                ValueList valueList = (ValueList)cSSValue;
                this.handleListStart(valueList.isCommaSeparated());
                Iterator iterator = valueList.iterator();
                while (iterator.hasNext()) {
                    this.handleStyleValue((CSSValue)iterator.next());
                }
                this.handleListEnd(valueList.isCommaSeparated());
                break;
            }
            case TYPED: {
                this.handleTyped((CSSTypedValue)cSSValue);
                break;
            }
            default: {
                this.errorHandler.error(new ParseException(this.createErrorMessage("non.css.context", new Object[]{cSSValue.getCssText()}), -1, -1));
            }
        }
    }

    protected void handleListStart(boolean bl) {
    }

    protected void handleListEnd(boolean bl) {
    }

    private void handleTyped(CSSTypedValue cSSTypedValue) throws ParseException {
        switch (cSSTypedValue.getPrimitiveType()) {
            case NUMERIC: {
                this.handleNumber(cSSTypedValue.getUnitType(), cSSTypedValue.getFloatValue(cSSTypedValue.getUnitType()));
                break;
            }
            case EXPRESSION: {
                this.handleMathExpression((CSSExpressionValue)cSSTypedValue);
                break;
            }
            case MATH_FUNCTION: {
                this.handleMathFunction((CSSMathFunctionValue)cSSTypedValue);
                break;
            }
            case IDENT: {
                this.handleIdent(cSSTypedValue.getStringValue());
                break;
            }
            default: {
                this.errorHandler.error(new ParseException(this.createErrorMessage("non.css.context", new Object[]{cSSTypedValue.getCssText()}), -1, -1));
            }
        }
    }

    protected void handleNumber(short s, float f) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage("unexpected.value", new Object[]{Float.toString(f) + CSSUnit.dimensionUnitString((short)s)}), -1, -1));
    }

    protected void handleMathExpression(CSSExpressionValue cSSExpressionValue) throws ParseException {
        float f;
        short s;
        Evaluator evaluator = new Evaluator(this.getPreferredUnit());
        try {
            CSSTypedValue cSSTypedValue = evaluator.evaluateExpression(cSSExpressionValue);
            s = cSSTypedValue.getUnitType();
            if (s != this.getPreferredUnit()) {
                if (this.getPreferredUnit() == 0) {
                    throw new ParseException("Invalid unit.", -1, -1);
                }
                if (s == 0) {
                    s = this.getPreferredUnit();
                }
            }
            f = cSSTypedValue.getFloatValue(s);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException);
        }
        this.handleNumber(s, f);
    }

    protected void handleMathFunction(CSSMathFunctionValue cSSMathFunctionValue) throws ParseException {
        float f;
        short s;
        Evaluator evaluator = new Evaluator(this.getPreferredUnit());
        try {
            CSSNumberValue cSSNumberValue = evaluator.evaluateFunction(cSSMathFunctionValue);
            s = cSSNumberValue.getUnitType();
            if (s != this.getPreferredUnit()) {
                if (this.getPreferredUnit() == 0) {
                    throw new ParseException("Invalid unit.", -1, -1);
                }
                if (s == 0) {
                    s = this.getPreferredUnit();
                }
            }
            f = cSSNumberValue.getFloatValue(s);
        }
        catch (RuntimeException runtimeException) {
            throw new ParseException(runtimeException);
        }
        this.handleNumber(s, f);
    }

    protected short getPreferredUnit() {
        return 0;
    }

    protected void handleIdent(String string) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage("unexpected.identifier", new Object[]{string}), -1, -1));
    }

    protected abstract void doParse() throws ParseException, IOException;

    void checkForCalc() throws IOException {
        int n = this.reader.getLine();
        int n2 = this.reader.getColumn();
        char[] cArray = new char[]{'a', 'l', 'c', '('};
        char[] cArray2 = new char[]{'A', 'L', 'C', '('};
        char[] cArray3 = new char[4];
        this.reader.read(cArray3);
        if (AbstractParser.equalsAny(cArray, cArray2, cArray3)) {
            this.handleCalc(n, n2);
        } else {
            this.reportError("character.unexpected", new Object[]{this.current}, n, n2);
        }
    }

    private static boolean equalsAny(char[] cArray, char[] cArray2, char[] cArray3) {
        assert (cArray.length == cArray3.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray3[i];
            if (c == cArray[i] || c == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected void handleCalc(int n, int n2) throws CalcParseException {
        throw new CalcParseException("Cannot handle calc().", n, n2);
    }

    private void reportError(String string, Object[] objectArray, int n, int n2) {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, new Object[]{this.current}), n, n2));
    }

    protected void reportError(String string, Object[] objectArray) throws ParseException {
        this.errorHandler.error(new ParseException(this.createErrorMessage(string, objectArray), this.reader.getLine(), this.reader.getColumn()));
    }

    protected void reportCharacterExpectedError(char c, int n) {
        this.reportError("character.expected", new Object[]{Character.valueOf(c), n});
    }

    protected void reportUnexpectedCharacterError(int n) {
        this.reportError("character.unexpected", new Object[]{n});
    }

    protected String createErrorMessage(String string, Object[] objectArray) {
        try {
            return this.formatMessage(string, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    protected String getBundleClassName() {
        return BUNDLE_CLASSNAME;
    }

    protected void skipSpaces() throws IOException {
        while (true) {
            switch (this.current) {
                default: {
                    return;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
            }
            this.current = this.reader.read();
        }
    }

    protected void skipCommaSpaces() throws IOException {
        block6: while (true) {
            switch (this.current) {
                default: {
                    break block6;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    this.current = this.reader.read();
                    continue block6;
                }
            }
            break;
        }
        if (this.current == 44) {
            block7: while (true) {
                this.current = this.reader.read();
                switch (this.current) {
                    default: {
                        break block7;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block7;
                    }
                }
                break;
            }
        }
    }
}

