/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.font;

import io.sf.carte.echosvg.gvt.font.UnicodeRange;
import java.util.Arrays;

public class Kern {
    private int[] firstGlyphCodes;
    private int[] secondGlyphCodes;
    private UnicodeRange[] firstUnicodeRanges;
    private UnicodeRange[] secondUnicodeRanges;
    private float kerningAdjust;

    public Kern(int[] nArray, int[] nArray2, UnicodeRange[] unicodeRangeArray, UnicodeRange[] unicodeRangeArray2, float f) {
        this.firstGlyphCodes = nArray;
        this.secondGlyphCodes = nArray2;
        this.firstUnicodeRanges = unicodeRangeArray;
        this.secondUnicodeRanges = unicodeRangeArray2;
        this.kerningAdjust = f;
        if (nArray != null) {
            Arrays.sort(this.firstGlyphCodes);
        }
        if (nArray2 != null) {
            Arrays.sort(this.secondGlyphCodes);
        }
    }

    public boolean matchesFirstGlyph(int n, String string) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        for (UnicodeRange unicodeRange : this.firstUnicodeRanges) {
            if (!unicodeRange.contains(n2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesFirstGlyph(int n, char c) {
        int n2;
        if (this.firstGlyphCodes != null && (n2 = Arrays.binarySearch(this.firstGlyphCodes, n)) >= 0) {
            return true;
        }
        for (UnicodeRange unicodeRange : this.firstUnicodeRanges) {
            if (!unicodeRange.contains(c)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, String string) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        if (string.length() < 1) {
            return false;
        }
        n2 = string.charAt(0);
        for (UnicodeRange unicodeRange : this.secondUnicodeRanges) {
            if (!unicodeRange.contains(n2)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesSecondGlyph(int n, char c) {
        int n2;
        if (this.secondGlyphCodes != null && (n2 = Arrays.binarySearch(this.secondGlyphCodes, n)) >= 0) {
            return true;
        }
        for (UnicodeRange unicodeRange : this.secondUnicodeRanges) {
            if (!unicodeRange.contains(c)) continue;
            return true;
        }
        return false;
    }

    public float getAdjustValue() {
        return this.kerningAdjust;
    }
}

