WPE_GeneratorsOfGroup := function(G)
    gens := GeneratorsOfGroup(G);
    if IsEmpty(gens) then
        gens := [()];
    fi;
    return gens;
end;

Generate := function(K, H, stream)
    local G, size;
    G := WreathProductProductAction(K, H);
    AppendTo(stream, "gap> K := Group(", WPE_GeneratorsOfGroup(K), ");;\n");
    AppendTo(stream, "gap> H := Group(", WPE_GeneratorsOfGroup(H), ");;\n");
    p := ExtRepPolynomialRatFun(CycleIndex(G));
    AppendTo(stream, "gap> p := ", p, ";;\n");
    AppendTo(stream, "gap> TestCycleIndexProductAction(K, H, p);\n");
    AppendTo(stream, "true\n");
end;

file := "out/testCycleIndexProductAction.tst";
stream:=OutputTextFile(file, false);
SetPrintFormattingStatus(stream, false);
PrintTo(stream);
AppendTo(stream, "gap> # Generated by dev/tests/cycleIndexPA/generate.g\n");
AppendTo(stream, "gap> ReadPackage(\"WPE\",\"tst/testCycleIndex.g\");;\n");

K := SymmetricGroup(1);
H := SymmetricGroup(1);
Generate(K, H, stream);

K := SymmetricGroup(1);
H := SymmetricGroup(5);
Generate(K, H, stream);

K := SymmetricGroup(1);
H := AlternatingGroup(5);
Generate(K, H, stream);

K := SymmetricGroup(4);
H := SymmetricGroup(1);
Generate(K, H, stream);

K := AlternatingGroup(4);
H := SymmetricGroup(1);
Generate(K, H, stream);

K := SymmetricGroup(4);
H := SymmetricGroup(5);
Generate(K, H, stream);

K := SymmetricGroup(4);
H := AlternatingGroup(5);
Generate(K, H, stream);

K := SymmetricGroup(4);
H := DihedralGroup(IsPermGroup, 10);
Generate(K, H, stream);

K := SymmetricGroup(4);
H := Group((1,2,3)(4,5));
Generate(K, H, stream);
