/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.overview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.View;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.MapBookmarks;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.overview.MapViewPane;

public class BookmarkToolbarPane
extends JComponent
implements IMapViewChangeListener,
IFreeplanePropertyListener,
IMapChangeListener,
INodeSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final String BOOKMARKS_TOOLBAR_VISIBLE_PROPERTY = "bookmarksToolbarVisible";
    private static final String BOOKMARKS_TOOLBAR_VISIBLE_FS_PROPERTY = "bookmarksToolbarVisible.fullscreen";
    private final Component rootWindow;
    private BookmarkToolbar bookmarksToolbar;
    private boolean isBookmarksToolbarVisible;
    private MapView currentSelectedMapView;
    private MapModel currentMap;
    private boolean bookmarksUpdateScheduled;

    public BookmarkToolbarPane(Component rootWindow) {
        this.rootWindow = rootWindow;
        this.setLayout(new BorderLayout(0, 0));
        ViewController viewController = Controller.getCurrentController().getViewController();
        this.isBookmarksToolbarVisible = viewController.isBookmarksToolbarVisible();
        this.add(rootWindow, "Center");
        Controller.getCurrentController().getMapViewManager().addMapViewChangeListener(this);
        ResourceController.getResourceController().addPropertyChangeListener(this);
        this.attachDockingWindowListeners(rootWindow);
        SwingUtilities.invokeLater(this::initializeToolbarForContainedMapViews);
    }

    private void attachDockingWindowListeners(Component window) {
        if (window instanceof DockingWindow) {
            ((DockingWindow)window).addListener((DockingWindowListener)this.createDockingWindowAdapter());
        }
    }

    private DockingWindowAdapter createDockingWindowAdapter() {
        return new DockingWindowAdapter(){

            public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
                MapView containedMapView;
                if (focusedView != null && SwingUtilities.isDescendingFrom((Component)focusedView, BookmarkToolbarPane.this.rootWindow) && (containedMapView = BookmarkToolbarPane.this.getContainedMapView(focusedView)) instanceof MapView) {
                    BookmarkToolbarPane.this.updateToolbarForMapView(containedMapView);
                }
            }

            public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
                MapView mapView;
                if ((BookmarkToolbarPane.this.currentSelectedMapView == null || !BookmarkToolbarPane.this.currentSelectedMapView.isSelected()) && addedWindow instanceof View && SwingUtilities.isDescendingFrom((Component)addedWindow, BookmarkToolbarPane.this.rootWindow) && (mapView = BookmarkToolbarPane.this.getContainedMapView((View)addedWindow)) != null) {
                    BookmarkToolbarPane.this.updateToolbarForMapView(mapView);
                }
            }

            public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
                MapView containedMapView;
                if (BookmarkToolbarPane.this.currentSelectedMapView != null && removedWindow instanceof View && (containedMapView = BookmarkToolbarPane.this.getContainedMapView((View)removedWindow)) == BookmarkToolbarPane.this.currentSelectedMapView) {
                    BookmarkToolbarPane.this.refreshToolbarForContainedMapViews();
                }
            }
        };
    }

    @Override
    public void afterViewChange(Component oldView, Component newView) {
        this.refreshToolbarForContainedMapViews();
    }

    @Override
    public void afterViewClose(Component oldView) {
        this.refreshToolbarForContainedMapViews();
    }

    @Override
    public void afterViewCreated(Component newView) {
        this.refreshToolbarForContainedMapViews();
    }

    @Override
    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        ViewController viewController;
        if (("fullscreen_enabled".equals(propertyName) || BOOKMARKS_TOOLBAR_VISIBLE_PROPERTY.equals(propertyName) || BOOKMARKS_TOOLBAR_VISIBLE_FS_PROPERTY.equals(propertyName)) && this.isBookmarksToolbarVisible != (viewController = Controller.getCurrentController().getViewController()).isBookmarksToolbarVisible()) {
            boolean bl = this.isBookmarksToolbarVisible = !this.isBookmarksToolbarVisible;
            if (this.bookmarksToolbar != null) {
                this.bookmarksToolbar.setVisible(this.isBookmarksToolbarVisible);
            }
            this.updateBookmarksToolbar();
        }
    }

    private boolean containsMapView(MapView mapView) {
        return SwingUtilities.isDescendingFrom(mapView, this.rootWindow);
    }

    private boolean isMindMapEditor(MapView mapView) {
        return mapView.getModeController().getModeName().equals("MindMap");
    }

    private MapView getContainedMapView(View dockedWindow) {
        if (dockedWindow.getComponent() instanceof MapViewPane) {
            MapViewPane mapViewPane = (MapViewPane)dockedWindow.getComponent();
            return (MapView)mapViewPane.getMapViewScrollPane().getViewport().getView();
        }
        return null;
    }

    private void initializeToolbarForContainedMapViews() {
        this.refreshToolbarForContainedMapViews();
    }

    private void refreshToolbarForContainedMapViews() {
        MapView mapViewToUse;
        List<? extends Component> mapViews = Controller.getCurrentController().getMapViewManager().getMapViews();
        MapView foundMapView = null;
        MapView selectedMapView = null;
        for (Component component : mapViews) {
            MapView mapView;
            if (!(component instanceof MapView) || !(mapView = (MapView)component).isShowing() || !this.containsMapView(mapView)) continue;
            if (foundMapView == null) {
                foundMapView = mapView;
            }
            if (!mapView.isSelected()) continue;
            selectedMapView = mapView;
            break;
        }
        MapView mapView = mapViewToUse = selectedMapView != null ? selectedMapView : foundMapView;
        if (mapViewToUse != null) {
            this.updateToolbarForMapView(mapViewToUse);
        } else {
            if (this.bookmarksToolbar != null) {
                this.remove((Component)this.bookmarksToolbar);
                this.bookmarksToolbar = null;
            }
            this.currentSelectedMapView = null;
            if (this.currentMap != null) {
                this.currentMap.removeMapChangeListener(this);
                this.currentMap = null;
            }
        }
    }

    private void updateToolbarForMapView(MapView mapView) {
        if (this.currentSelectedMapView == mapView) {
            return;
        }
        if (this.currentMap != null) {
            this.currentMap.removeMapChangeListener(this);
        }
        if (this.currentSelectedMapView != null) {
            this.currentSelectedMapView.getModeController().getMapController().removeNodeSelectionListener(this);
        }
        this.currentSelectedMapView = mapView;
        this.currentMap = mapView.getMap();
        boolean isMindMapEditor = this.isMindMapEditor(mapView);
        boolean bl = this.isBookmarksToolbarVisible = isMindMapEditor && Controller.getCurrentController().getViewController().isBookmarksToolbarVisible();
        if (isMindMapEditor) {
            if (this.bookmarksToolbar == null) {
                BookmarksController bookmarksController = mapView.getModeController().getExtension(BookmarksController.class);
                this.bookmarksToolbar = new BookmarkToolbar(bookmarksController, this.currentMap);
                this.bookmarksToolbar.setReducesButtonSize(false);
                this.bookmarksToolbar.setVisible(this.isBookmarksToolbarVisible);
                this.add((Component)this.bookmarksToolbar, "South");
            } else {
                this.bookmarksToolbar.setMap(this.currentMap);
                this.bookmarksToolbar.setVisible(this.isBookmarksToolbarVisible);
            }
        } else if (this.bookmarksToolbar != null) {
            this.remove((Component)this.bookmarksToolbar);
            this.bookmarksToolbar = null;
        }
        if (this.currentMap != null) {
            this.currentMap.addMapChangeListener(this);
        }
        if (this.currentSelectedMapView != null && isMindMapEditor) {
            this.currentSelectedMapView.getModeController().getMapController().addNodeSelectionListener(this);
        }
        this.updateBookmarksToolbar();
    }

    private void updateBookmarksToolbar() {
        BookmarksController bookmarksController;
        if (this.currentSelectedMapView != null && this.isBookmarksToolbarVisible && this.bookmarksToolbar != null && (bookmarksController = this.currentSelectedMapView.getModeController().getExtension(BookmarksController.class)) != null) {
            bookmarksController.updateBookmarksToolbar(this.bookmarksToolbar, this.currentSelectedMapView.getMap());
        }
        this.bookmarksUpdateScheduled = false;
    }

    private void updateBookmarksToolbarLater() {
        if (this.currentSelectedMapView != null && !this.bookmarksUpdateScheduled) {
            this.bookmarksUpdateScheduled = true;
            SwingUtilities.invokeLater(this::updateBookmarksToolbar);
        }
    }

    public void requestFocusForBookmarkToolbar() {
        if (this.isBookmarksToolbarVisible && this.bookmarksToolbar != null) {
            this.bookmarksToolbar.requestInitialFocusInWindow();
        }
    }

    @Override
    public void mapChanged(MapChangeEvent event) {
        if (event.getMap() != this.currentMap) {
            return;
        }
        Object property = event.getProperty();
        if (property.equals(MapBookmarks.class) || property.equals(Filter.class)) {
            this.updateBookmarksToolbarLater();
            return;
        }
        if (property.equals(MapView.class) && event.getOldValue() == this.currentSelectedMapView) {
            if (this.currentMap != null) {
                this.currentMap.removeMapChangeListener(this);
            }
            MapModel mapModel = this.currentMap = this.currentSelectedMapView != null ? this.currentSelectedMapView.getMap() : null;
            if (this.currentMap != null) {
                this.currentMap.addMapChangeListener(this);
            }
        }
        if (property.equals((Object)IMapViewManager.MapChangeEventProperty.MAP_VIEW_ROOT) && this.bookmarksToolbar != null) {
            this.bookmarksToolbar.repaint();
        }
    }

    @Override
    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        if (this.currentSelectedMapView != null && nodeDeletionEvent.parent.getMap() == this.currentSelectedMapView.getMap()) {
            this.updateBookmarksToolbarLater();
        }
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int newIndex) {
        if (this.currentSelectedMapView != null && child.getMap() == this.currentSelectedMapView.getMap()) {
            this.updateBookmarksToolbarLater();
        }
    }

    @Override
    public void onSelect(NodeModel node) {
        JComponent selectedMapView;
        if (this.currentSelectedMapView == null && (selectedMapView = Controller.getCurrentController().getMapViewManager().getMapViewComponent()) instanceof MapView && SwingUtilities.isDescendingFrom(selectedMapView, this.rootWindow)) {
            this.updateToolbarForMapView((MapView)selectedMapView);
        }
        if (this.currentSelectedMapView != null && this.currentSelectedMapView.isSelected()) {
            this.updateBookmarksToolbarLater();
        }
    }

    public void dispose() {
        Controller.getCurrentController().getMapViewManager().removeMapViewChangeListener(this);
        ResourceController.getResourceController().removePropertyChangeListener(this);
        if (this.currentMap != null) {
            this.currentMap.removeMapChangeListener(this);
            this.currentMap = null;
        }
        if (this.currentSelectedMapView != null) {
            this.currentSelectedMapView.getModeController().getMapController().removeNodeSelectionListener(this);
            this.currentSelectedMapView = null;
        }
    }
}

