/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableIndex;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.utils.CommonUtils;

public abstract class SQLIndexManager<OBJECT_TYPE extends AbstractTableIndex, TABLE_TYPE extends AbstractTable>
extends SQLObjectEditor<OBJECT_TYPE, TABLE_TYPE> {
    @Override
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    @Override
    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        AbstractTable table = (AbstractTable)((AbstractTableIndex)command.getObject()).getTable();
        AbstractTableIndex index = (AbstractTableIndex)command.getObject();
        String indexName = DBUtils.getQuotedIdentifier(index.getDataSource(), index.getName());
        if (index instanceof DBPNamedObject2) {
            ((DBPNamedObject2)((Object)index)).setName(indexName);
        } else {
            log.error("Cannot set index name");
        }
        String tableName = DBUtils.getEntityScriptName(table, options);
        StringBuilder decl = new StringBuilder(40);
        decl.append("CREATE");
        this.appendIndexModifiers(index, decl);
        decl.append(" INDEX ").append(indexName);
        this.appendIndexType(index, decl);
        decl.append(" ON ").append(tableName).append(" (");
        try {
            boolean firstColumn = true;
            for (DBSTableIndexColumn indexColumn : CommonUtils.safeCollection(((AbstractTableIndex)command.getObject()).getAttributeReferences(new VoidProgressMonitor()))) {
                if (!firstColumn) {
                    decl.append(",");
                }
                firstColumn = false;
                decl.append(DBUtils.getQuotedIdentifier(indexColumn));
                this.appendIndexColumnModifiers(monitor, decl, indexColumn);
            }
        }
        catch (DBException e) {
            log.error(e);
        }
        decl.append(")");
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, decl.toString()));
    }

    protected void appendIndexType(OBJECT_TYPE index, StringBuilder decl) {
    }

    protected void appendIndexModifiers(OBJECT_TYPE index, StringBuilder decl) {
        if (index.isUnique()) {
            decl.append(" UNIQUE");
        }
    }

    protected void appendIndexColumnModifiers(DBRProgressMonitor monitor, StringBuilder decl, DBSTableIndexColumn indexColumn) {
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    @Override
    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_index, this.getDropIndexPattern((AbstractTableIndex)command.getObject()).replace("%TABLE%", DBUtils.getObjectFullName(((AbstractTableIndex)command.getObject()).getTable(), DBPEvaluationContext.DDL)).replace("%INDEX%", ((AbstractTableIndex)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)).replace("%INDEX_SHORT%", DBUtils.getQuotedIdentifier((DBSObject)command.getObject()))));
    }

    protected String getDropIndexPattern(OBJECT_TYPE index) {
        return "DROP INDEX %INDEX%";
    }
}

