/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.ResultSetCache;
import org.eclipse.birt.data.engine.executor.transform.OrderingInfo;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class SmartRowResultSet
implements IRowResultSet {
    private ResultSetCache rsCache;
    private IResultClass rsMeta;
    private OrderingInfo orderingInfo;
    boolean startNewGroup = true;
    int currentGroup = -1;

    public SmartRowResultSet(ResultSetCache rsCache, IResultClass rsMeta, OrderingInfo orderingInfo) {
        this.rsCache = rsCache;
        this.rsMeta = rsMeta;
        this.orderingInfo = orderingInfo;
    }

    @Override
    public IResultClass getMetaData() {
        return this.rsMeta;
    }

    @Override
    public IResultObject next() throws DataException {
        IResultObject result = null;
        if (this.startNewGroup) {
            ++this.currentGroup;
            if (this.currentGroup > this.orderingInfo.getCount() - 1) {
                return null;
            }
            this.rsCache.moveTo(this.orderingInfo.getStartIndex(this.currentGroup));
            this.startNewGroup = false;
        } else {
            this.rsCache.next();
        }
        result = this.rsCache.getCurrentResult();
        if (this.rsCache.getCurrentIndex() == this.orderingInfo.getEndIndex(this.currentGroup)) {
            this.startNewGroup = true;
        }
        return result;
    }

    @Override
    public int getIndex() throws DataException {
        return this.rsCache.getCurrentIndex();
    }
}

