/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.synchronize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.synchronize.filesystem.FileSystemProvider;
import org.eclipse.rse.internal.synchronize.provisional.ISynchronizeFilter;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSESyncUtils {
    public static final String PLUGIN_ID = "org.eclipse.rse.internal.synchronize";
    public static final String PROVIDER_ID = FileSystemProvider.class.getName();

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = RemoteImportExportPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public static void getSynchronizeResources(IResource local, ISynchronizeFilter filter, List<IResource> resources) throws CoreException {
        if (!filter.isExcluded(local.getFullPath())) {
            resources.add(local);
        }
        if (local.getType() != 1) {
            IResource[] iResourceArray = ((IContainer)local).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                RSESyncUtils.getSynchronizeResources(resource, filter, resources);
                ++n2;
            }
        }
    }

    public static void getSynchronizeResources(IResource localRoot, IRemoteFile remote, IRemoteFile remoteRoot, ISynchronizeFilter filter, List<IResource> resources) throws SystemMessageException, CoreException {
        if (!filter.isExcluded((IPath)new Path(remote.getAbsolutePathPlusConnection()))) {
            String relativePath = remote.getAbsolutePath().replace(remoteRoot.getAbsolutePath(), "");
            if (remote.isFile()) {
                resources.add((IResource)((IProject)localRoot).getFile(relativePath));
            } else {
                resources.add((IResource)((IProject)localRoot).getFolder(relativePath));
            }
        }
        if (!remote.isFile()) {
            IRemoteFile[] iRemoteFileArray = remote.getParentRemoteFileSubSystem().list(remote, null);
            int n = iRemoteFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRemoteFile remoteFile = iRemoteFileArray[n2];
                RSESyncUtils.getSynchronizeResources(localRoot, remoteFile, remoteRoot, filter, resources);
                ++n2;
            }
        }
    }

    public static void saveDescription(RemoteFileExportData exportData) throws CoreException, IOException {
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IRemoteFileExportDescriptionWriter writer = exportData.createExportDescriptionWriter(objectStreamOutput);
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(exportData);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = exportData.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                descriptionFile.setContents((InputStream)fileInput, true, true, null);
            } else {
                IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(descriptionFile.getFullPath());
                if (variant == null) {
                    IContainer parent = descriptionFile.getParent();
                    if (parent != null) {
                        IResource parentVariant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(parent.getFullPath());
                        if (parentVariant == null) {
                            descriptionFile.create((InputStream)fileInput, true, null);
                        } else {
                            IPath newPath = parentVariant.getFullPath().append(descriptionFile.getName());
                            IFile newDescriptionFile = SystemBasePlugin.getWorkspace().getRoot().getFile(newPath);
                            newDescriptionFile.create((InputStream)fileInput, true, null);
                        }
                    }
                } else if (variant instanceof IFile) {
                    ((IFile)variant).setContents((InputStream)fileInput, true, true, null);
                }
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static void saveDescription(RemoteFileImportData importData) throws CoreException, IOException {
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IRemoteFileImportDescriptionWriter writer = importData.createImportDescriptionWriter(objectStreamOutput);
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(importData);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = importData.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                descriptionFile.setContents((InputStream)fileInput, true, true, null);
            } else {
                IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(descriptionFile.getFullPath());
                if (variant == null) {
                    IContainer parent = descriptionFile.getParent();
                    if (parent != null) {
                        IResource parentVariant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(parent.getFullPath());
                        if (parentVariant == null) {
                            descriptionFile.create((InputStream)fileInput, true, null);
                        } else {
                            IPath newPath = parentVariant.getFullPath().append(descriptionFile.getName());
                            IFile newDescriptionFile = SystemBasePlugin.getWorkspace().getRoot().getFile(newPath);
                            newDescriptionFile.create((InputStream)fileInput, true, null);
                        }
                    }
                } else if (variant instanceof IFile) {
                    ((IFile)variant).setContents((InputStream)fileInput, true, true, null);
                }
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

