/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.jni.NativeXutils;
import com.nvidia.viper.model.Executable;
import org.eclipse.core.runtime.Path;

public class SourceLocation {
    private String filePath;
    private int lineNumber;
    private String funcName;
    private long pcOffset;

    public SourceLocation(String fileName, int lineNumber, String funcName, long pcOffset) {
        this.filePath = fileName;
        this.lineNumber = lineNumber;
        this.funcName = funcName;
        this.pcOffset = pcOffset;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceLocation) {
            SourceLocation other = (SourceLocation)obj;
            return this.filePath.equals(other.filePath) && this.lineNumber == other.lineNumber && this.pcOffset == other.pcOffset;
        }
        return false;
    }

    public int hashCode() {
        return this.filePath.hashCode() + this.lineNumber + Long.toString(this.pcOffset).hashCode();
    }

    public static SourceLocation getSourceLocation(Executable executable, long pc) {
        SourceLocation sourceLocation = null;
        if (executable != null) {
            sourceLocation = NativeXutils.correlateCpuSource(pc, executable.getLocalFilename(), executable.getPgExplainFile());
        }
        return sourceLocation;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        Path path = new Path(this.getFilePath());
        int numberOfSegments = path.segmentCount();
        int i = 0;
        while (i < numberOfSegments) {
            String testSegment = path.segment(i);
            if (testSegment.compareTo(".") == 0) {
                return path.removeFirstSegments(i).toString();
            }
            ++i;
        }
        return path.lastSegment();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFuncName() {
        return this.funcName;
    }

    public long getPcOffset() {
        return this.pcOffset;
    }

    public String toString() {
        return String.valueOf(this.getFuncName()) + "@" + this.getFileName() + ":" + this.getLineNumber();
    }
}

