﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/geo-routes/GeoRoutes_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace GeoRoutes
{
namespace Model
{
  enum class MatchingStrategy
  {
    NOT_SET,
    MatchAny,
    MatchMostSignificantRoad
  };

namespace MatchingStrategyMapper
{
AWS_GEOROUTES_API MatchingStrategy GetMatchingStrategyForName(const Aws::String& name);

AWS_GEOROUTES_API Aws::String GetNameForMatchingStrategy(MatchingStrategy value);
} // namespace MatchingStrategyMapper
} // namespace Model
} // namespace GeoRoutes
} // namespace Aws
