﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws
{
namespace CognitoIdentityProvider
{
namespace Model
{
  enum class UserPoolTierType
  {
    NOT_SET,
    LITE,
    ESSENTIALS,
    PLUS
  };

namespace UserPoolTierTypeMapper
{
AWS_COGNITOIDENTITYPROVIDER_API UserPoolTierType GetUserPoolTierTypeForName(const Aws::String& name);

AWS_COGNITOIDENTITYPROVIDER_API Aws::String GetNameForUserPoolTierType(UserPoolTierType value);
} // namespace UserPoolTierTypeMapper
} // namespace Model
} // namespace CognitoIdentityProvider
} // namespace Aws
