untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8ol/WcQjGFBIGmZhA8lJJf3CgyfdqxdYqKg3hIHDuhgWhKrftKbWA3OyjJnrjpfC+JjLBZ8fw9X2c2nckxXYGsAM=

OpenBSD 7.6 errata 021, July 1, 2025:

TIOCUCNTL ioctl(2) could crash the kernel if called with a non-file
argument.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 021_pledge.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/kern/kern_pledge.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_pledge.c,v
diff -u -p -r1.320 kern_pledge.c
--- sys/kern/kern_pledge.c	24 Sep 2024 02:22:42 -0000	1.320
+++ sys/kern/kern_pledge.c	29 Jun 2025 07:38:45 -0000
@@ -1269,9 +1269,11 @@ pledge_ioctl(struct proc *p, long com, s
 				break;
 			if ((pledge & PLEDGE_WPATH) == 0)
 				break;
-			if (cdevsw[major(vp->v_rdev)].d_open != ptcopen)
-				break;
-			return (0);
+			if (fp->f_type == DTYPE_VNODE &&
+			    vp->v_type == VCHR &&
+			    cdevsw[major(vp->v_rdev)].d_open == ptcopen)
+				return (0);
+			break;
 #endif /* NPTY > 0 */
 		case TIOCSPGRP:
 			if ((pledge & PLEDGE_PROC) == 0)
