untrusted comment: verify with openbsd-73-base.pub
RWQS90bYzZ4XFvgRe0GZosgD3QrwAFhav0T9arbUw7iVlcavyYZ2MJlcmeQF3ZZfWVHRvPm8+/e92wsZ8LE5FUBAHspR8OH4PQw=

OpenBSD 7.3 errata 003, May 26, 2023:

IP address inheritance was handled incorrectly in rpki-client(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-73-base.pub -x 003_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild rpki-client(8):
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/validate.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/validate.c,v
diff -u -p -r1.55 validate.c
--- usr.sbin/rpki-client/validate.c	6 Mar 2023 16:04:52 -0000	1.55
+++ usr.sbin/rpki-client/validate.c	15 May 2023 04:47:22 -0000
@@ -145,6 +145,8 @@ valid_cert(const char *fn, struct auth *
 	}
 
 	for (i = 0; i < cert->ipsz; i++) {
+		if (cert->ips[i].type == CERT_IP_INHERIT)
+			continue;
 		if (valid_ip(a, cert->ips[i].afi, cert->ips[i].min,
 		    cert->ips[i].max))
 			continue;
