untrusted comment: verify with openbsd-72-base.pub
RWQTKNnK3CZZ8I+6hdi5gX2/K3o8d6acY8hNRUViT6VqTmUOTZH3c+Wo4eB1TnPnqb9gPYd60wpe+qKUkB3gW6HxxiQ0jdlKfQo=

OpenBSD 7.2 errata 025, May 26, 2023:

IP address inheritance was handled incorrectly in rpki-client(8).

Apply by doing:
    signify -Vep /etc/signify/openbsd-72-base.pub -x 025_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild rpki-client(8):
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/validate.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/validate.c,v
diff -u -p -r1.45 validate.c
--- usr.sbin/rpki-client/validate.c	3 Sep 2022 14:41:47 -0000	1.45
+++ usr.sbin/rpki-client/validate.c	15 May 2023 04:47:13 -0000
@@ -148,6 +148,8 @@ valid_cert(const char *fn, struct auth *
 	}
 
 	for (i = 0; i < cert->ipsz; i++) {
+		if (cert->ips[i].type == CERT_IP_INHERIT)
+			continue;
 		if (valid_ip(a, cert->ips[i].afi, cert->ips[i].min,
 		    cert->ips[i].max))
 			continue;
