/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config.delegate;

import com.beust.jcommander.Parameter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.config.converters.NamedGroupConverter;
import de.rub.nds.tlsattacker.core.config.converters.PointFormatConverter;
import de.rub.nds.tlsattacker.core.config.delegate.Delegate;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import java.util.Collections;
import java.util.List;

public class NamedGroupsDelegate
extends Delegate {
    @Parameter(names={"-point_formats"}, description="Sets the elliptic curve point formats, divided by a comma", converter=PointFormatConverter.class)
    private List<ECPointFormat> pointFormats = null;
    @Parameter(names={"-named_group"}, description="Named groups to be used, divided by a comma", converter=NamedGroupConverter.class)
    private List<NamedGroup> namedGroups = null;

    public List<ECPointFormat> getPointFormats() {
        if (this.pointFormats == null) {
            return null;
        }
        return Collections.unmodifiableList(this.pointFormats);
    }

    public void setPointFormats(List<ECPointFormat> pointFormats) {
        this.pointFormats = pointFormats;
    }

    public List<NamedGroup> getNamedGroups() {
        if (this.namedGroups == null) {
            return null;
        }
        return Collections.unmodifiableList(this.namedGroups);
    }

    public void setNamedGroups(List<NamedGroup> namedGroups) {
        this.namedGroups = namedGroups;
    }

    @Override
    public void applyDelegate(Config config) {
        if (this.namedGroups != null) {
            config.setDefaultClientNamedGroups(this.namedGroups);
            config.setDefaultServerNamedGroups(this.namedGroups);
            config.setDefaultSelectedNamedGroup(this.namedGroups.get(0));
        }
        if (this.pointFormats != null) {
            config.setDefaultServerSupportedPointFormats(this.pointFormats);
            config.setDefaultClientSupportedPointFormats(this.pointFormats);
        }
    }
}

