/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xeustechnologies.jcl.Configuration;
import org.xeustechnologies.jcl.JarResources;
import org.xeustechnologies.jcl.JclJarEntry;
import org.xeustechnologies.jcl.exception.JclException;
import org.xeustechnologies.jcl.exception.ResourceNotFoundException;

public class ClasspathResources
extends JarResources {
    private final transient Logger logger = LoggerFactory.getLogger(ClasspathResources.class);
    private boolean ignoreMissingResources = Configuration.suppressMissingResourceException();

    private void loadResourceContent(String resource2, String pack) {
        File resourceFile = new File(resource2);
        String entryName = "";
        FileInputStream fis = null;
        byte[] content2 = null;
        try {
            fis = new FileInputStream(resourceFile);
            content2 = new byte[(int)resourceFile.length()];
            if (fis.read(content2) != -1) {
                if (pack.length() > 0) {
                    entryName = pack + "/";
                }
                if (this.jarEntryContents.containsKey(entryName = entryName + resourceFile.getName())) {
                    if (!this.collisionAllowed) {
                        throw new JclException("Resource " + entryName + " already loaded");
                    }
                    this.logger.debug("Resource {} already loaded; ignoring entry...", (Object)entryName);
                    return;
                }
                this.logger.debug("Loading resource: {}", (Object)entryName);
                JclJarEntry entry = new JclJarEntry();
                File parentFile = resourceFile.getAbsoluteFile().getParentFile();
                if (parentFile == null) {
                    entry.setBaseUrl("file:/");
                } else {
                    entry.setBaseUrl(parentFile.toURI().toString());
                }
                entry.setResourceBytes(content2);
                this.jarEntryContents.put(entryName, entry);
            }
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                throw new JclException(e);
            }
        }
    }

    private void loadRemoteResource(URL url) {
        this.logger.debug("Attempting to load a remote resource.");
        if (url.toString().toLowerCase().endsWith(".jar")) {
            this.loadJar(url);
            return;
        }
        InputStream stream = null;
        ByteArrayOutputStream out = null;
        try {
            int byt;
            stream = url.openStream();
            out = new ByteArrayOutputStream();
            while ((byt = stream.read()) != -1) {
                out.write(byt);
            }
            byte[] content2 = out.toByteArray();
            if (this.jarEntryContents.containsKey(url.toString())) {
                if (!this.collisionAllowed) {
                    throw new JclException("Resource " + url.toString() + " already loaded");
                }
                this.logger.debug("Resource {} already loaded; ignoring entry...", (Object)url.toString());
                return;
            }
            this.logger.debug("Loading remote resource.");
            JclJarEntry entry = new JclJarEntry();
            entry.setResourceBytes(content2);
            this.jarEntryContents.put(url.toString(), entry);
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new JclException(e);
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new JclException(e);
                }
            }
        }
    }

    private void loadClassContent(String clazz, String pack) {
        File cf = new File(clazz);
        FileInputStream fis = null;
        String entryName = "";
        byte[] content2 = null;
        try {
            fis = new FileInputStream(cf);
            content2 = new byte[(int)cf.length()];
            if (fis.read(content2) != -1) {
                entryName = pack + "/" + cf.getName();
                if (this.jarEntryContents.containsKey(entryName)) {
                    if (!this.collisionAllowed) {
                        throw new JclException("Class " + entryName + " already loaded");
                    }
                    this.logger.debug("Class {} already loaded; ignoring entry...", (Object)entryName);
                    return;
                }
                this.logger.debug("Loading class: {}", (Object)entryName);
                JclJarEntry entry = new JclJarEntry();
                entry.setResourceBytes(content2);
                this.jarEntryContents.put(entryName, entry);
            }
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new JclException(e);
                }
            }
        }
    }

    public void loadResource(URL url) {
        try {
            this.loadResource(new File(url.toURI()), "");
        }
        catch (IllegalArgumentException iae) {
            this.loadRemoteResource(url);
        }
        catch (URISyntaxException e) {
            throw new JclException("URISyntaxException", e);
        }
    }

    public void loadResource(String path) {
        this.logger.debug("Resource: {}", (Object)path);
        File fp = new File(path);
        if (!fp.exists() && !this.ignoreMissingResources) {
            throw new JclException("File/Path does not exist");
        }
        this.loadResource(fp, "");
    }

    private void loadResource(File fol, String packName) {
        if (fol.isFile()) {
            if (fol.getName().toLowerCase().endsWith(".class")) {
                this.loadClassContent(fol.getAbsolutePath(), packName);
            } else if (fol.getName().toLowerCase().endsWith(".jar")) {
                this.loadJar(fol.getAbsolutePath());
            } else {
                this.loadResourceContent(fol.getAbsolutePath(), packName);
            }
            return;
        }
        if (fol.list() != null) {
            for (String f : fol.list()) {
                File fl = new File(fol.getAbsolutePath() + "/" + f);
                String pn = packName;
                if (fl.isDirectory()) {
                    if (!pn.equals("")) {
                        pn = pn + "/";
                    }
                    pn = pn + fl.getName();
                }
                this.loadResource(fl, pn);
            }
        }
    }

    public void unload(String resource2) {
        if (!this.jarEntryContents.containsKey(resource2)) {
            throw new ResourceNotFoundException(resource2, "Resource not found in local ClasspathResources");
        }
        this.logger.debug("Removing resource {}", (Object)resource2);
        this.jarEntryContents.remove(resource2);
    }

    public boolean isCollisionAllowed() {
        return this.collisionAllowed;
    }

    public void setCollisionAllowed(boolean collisionAllowed) {
        this.collisionAllowed = collisionAllowed;
    }

    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }
}

