/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest.move;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.rest.BadRequestExceptionWithMessage;
import org.jitsi.jicofo.rest.move.MoveEndpointsKt;
import org.jitsi.jicofo.rest.move.NotFoundExceptionWithMessage;
import org.jitsi.jicofo.rest.move.Result;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

@Path(value="/move-endpoints")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014H\u0002J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0018H\u0002J&\u0010\u001b\u001a\u00020\u00102\b\b\u0001\u0010\u001a\u001a\u00020\u00182\b\b\u0001\u0010\u001c\u001a\u00020\u00182\b\b\u0001\u0010\u001d\u001a\u00020\u0018H\u0007J&\u0010\u001e\u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u00182\b\b\u0001\u0010\u001a\u001a\u00020\u00182\b\b\u0001\u0010\u001f\u001a\u00020\u0016H\u0007J\u001c\u0010 \u001a\u00020\u00102\b\b\u0001\u0010\u001d\u001a\u00020\u00182\b\b\u0001\u0010!\u001a\u00020\"H\u0007J\u001e\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160%0$*\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/jitsi/jicofo/rest/move/MoveEndpoints;", "", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "(Lorg/jitsi/jicofo/ConferenceStore;Lorg/jitsi/jicofo/bridge/BridgeSelector;)V", "getBridgeSelector", "()Lorg/jitsi/jicofo/bridge/BridgeSelector;", "getConferenceStore", "()Lorg/jitsi/jicofo/ConferenceStore;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "doMove", "Lorg/jitsi/jicofo/rest/move/Result;", "bridge", "Lorg/jitsi/jicofo/bridge/Bridge;", "endpointsToMove", "", "Lorg/jitsi/jicofo/conference/JitsiMeetConference;", "", "getBridge", "", "getConference", "conferenceId", "moveEndpoint", "endpointId", "bridgeId", "moveEndpoints", "numEndpoints", "moveFraction", "fraction", "", "getConferences", "", "Lkotlin/Pair;", "jicofo"})
@SourceDebugExtension(value={"SMAP\nMoveEndpoints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveEndpoints.kt\norg/jitsi/jicofo/rest/move/MoveEndpoints\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,249:1\n766#2:250\n857#2,2:251\n1603#2,9:256\n1855#2:265\n1856#2:267\n1612#2:268\n1054#2:269\n1#3:253\n1#3:266\n215#4,2:254\n*S KotlinDebug\n*F\n+ 1 MoveEndpoints.kt\norg/jitsi/jicofo/rest/move/MoveEndpoints\n*L\n124#1:250\n124#1:251,2\n201#1:256,9\n201#1:265\n201#1:267\n201#1:268\n203#1:269\n201#1:266\n165#1:254,2\n*E\n"})
public final class MoveEndpoints {
    @NotNull
    private final ConferenceStore conferenceStore;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @NotNull
    private final Logger logger;

    public MoveEndpoints(@NotNull ConferenceStore conferenceStore, @NotNull BridgeSelector bridgeSelector) {
        Intrinsics.checkNotNullParameter(conferenceStore, "conferenceStore");
        Intrinsics.checkNotNullParameter(bridgeSelector, "bridgeSelector");
        this.conferenceStore = conferenceStore;
        this.bridgeSelector = bridgeSelector;
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    }

    @NotNull
    public final ConferenceStore getConferenceStore() {
        return this.conferenceStore;
    }

    @NotNull
    public final BridgeSelector getBridgeSelector() {
        return this.bridgeSelector;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Path(value="move-endpoint")
    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final Result moveEndpoint(@QueryParam(value="conference") @DefaultValue(value="") @NotNull String conferenceId, @QueryParam(value="endpoint") @DefaultValue(value="") @NotNull String endpointId, @QueryParam(value="bridge") @DefaultValue(value="") @NotNull String bridgeId) {
        Result result;
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        Intrinsics.checkNotNullParameter(endpointId, "endpointId");
        Intrinsics.checkNotNullParameter(bridgeId, "bridgeId");
        if (((CharSequence)conferenceId).length() == 0) {
            throw new BadRequestExceptionWithMessage("Conference ID is missing");
        }
        if (((CharSequence)endpointId).length() == 0) {
            throw new BadRequestExceptionWithMessage("Endpoint ID is missing");
        }
        Bridge bridge2 = ((CharSequence)bridgeId).length() == 0 ? null : this.getBridge(bridgeId);
        JitsiMeetConference conference = this.getConference(conferenceId);
        this.logger.info("Moving conference=" + conferenceId + " endpoint=" + endpointId + " bridge=" + bridgeId);
        if (conference.moveEndpoint(endpointId, bridge2)) {
            this.logger.info("Moved successfully");
            result = new Result(1, 1);
        } else {
            this.logger.info("Failed to move");
            result = new Result(0, 0);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Path(value="move-endpoints")
    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final Result moveEndpoints(@QueryParam(value="bridge") @DefaultValue(value="") @NotNull String bridgeId, @QueryParam(value="conference") @DefaultValue(value="") @NotNull String conferenceId, @QueryParam(value="endpoints") @DefaultValue(value="1") int numEndpoints) {
        List list;
        JitsiMeetConference conference;
        Intrinsics.checkNotNullParameter(bridgeId, "bridgeId");
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        if (((CharSequence)bridgeId).length() == 0) {
            throw new BadRequestExceptionWithMessage("Bridge JID is missing");
        }
        Bridge bridge2 = this.getBridge(bridgeId);
        JitsiMeetConference jitsiMeetConference = conference = ((CharSequence)conferenceId).length() == 0 ? null : this.getConference(conferenceId);
        if (conference == null) {
            list = this.getConferences(bridge2);
        } else {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.getConferences(bridge2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getFirst(), conference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List bridgeConferences = list;
        this.logger.info("Moving " + numEndpoints + " from bridge=" + bridge2.getJid() + " (conference=" + conference + ")");
        Map endpointsToMove = MoveEndpointsKt.access$select(bridgeConferences, numEndpoints);
        return this.doMove(bridge2, endpointsToMove);
    }

    /*
     * WARNING - void declaration
     */
    @Path(value="move-fraction")
    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final Result moveFraction(@QueryParam(value="bridge") @DefaultValue(value="") @NotNull String bridgeId, @QueryParam(value="fraction") @DefaultValue(value="0.1") double fraction) {
        Intrinsics.checkNotNullParameter(bridgeId, "bridgeId");
        if (((CharSequence)bridgeId).length() == 0) {
            throw new BadRequestExceptionWithMessage("Bridge JID is missing");
        }
        Bridge bridge2 = this.getBridge(bridgeId);
        List<Pair<JitsiMeetConference, Integer>> bridgeConferences = this.getConferences(bridge2);
        Iterable iterable = bridgeConferences;
        int n = 0;
        for (Object t : iterable) {
            void it;
            Pair pair = (Pair)t;
            int n2 = n;
            boolean bl = false;
            int n3 = ((Number)it.getSecond()).intValue();
            n = n2 + n3;
        }
        int totalEndpoints = n;
        int numEndpoints = MathKt.roundToInt(fraction * (double)totalEndpoints);
        this.logger.info("Moving " + fraction + " of endpoints from bridge=" + bridge2 + " (" + numEndpoints + " out of " + totalEndpoints + ")");
        Map endpointsToMove = MoveEndpointsKt.access$select(bridgeConferences, numEndpoints);
        return this.doMove(bridge2, endpointsToMove);
    }

    private final Result doMove(Bridge bridge2, Map<JitsiMeetConference, Integer> endpointsToMove) {
        this.logger.info("Moving endpoints from bridge " + bridge2.getJid() + ": " + endpointsToMove);
        int movedEndpoints = 0;
        int conferences = 0;
        Map<JitsiMeetConference, Integer> $this$forEach$iv = endpointsToMove;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<JitsiMeetConference, Integer>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<JitsiMeetConference, Integer> element$iv;
            Map.Entry<JitsiMeetConference, Integer> entry = element$iv = iterator2.next();
            boolean bl = false;
            JitsiMeetConference conference = entry.getKey();
            int numEps = ((Number)entry.getValue()).intValue();
            int moved = conference.moveEndpoints(bridge2, numEps);
            movedEndpoints += moved;
            if (moved <= 0) continue;
            ++conferences;
        }
        this.logger.info("Moved " + movedEndpoints + " endpoints from " + conferences + " conferences.");
        return new Result(movedEndpoints, conferences);
    }

    private final Bridge getBridge(String bridge2) {
        Jid jid;
        Jid jid2;
        try {
            jid2 = JidCreate.from(bridge2);
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage("Invalid bridge ID");
        }
        Jid bridgeJid = jid2;
        Intrinsics.checkNotNull(bridgeJid);
        Bridge bridge3 = this.bridgeSelector.get(bridgeJid);
        if (bridge3 != null) {
            Bridge it = bridge3;
            boolean bl = false;
            return it;
        }
        try {
            jid = JidCreate.from(BridgeConfig.config.getBreweryJid() + "/" + bridge2);
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage("Invalid bridge ID");
        }
        Jid bridgeFullJid = jid;
        Intrinsics.checkNotNull(bridgeFullJid);
        Bridge bridge4 = this.bridgeSelector.get(bridgeFullJid);
        if (bridge4 == null) {
            throw new NotFoundExceptionWithMessage("Bridge not found");
        }
        return bridge4;
    }

    private final JitsiMeetConference getConference(String conferenceId) {
        EntityBareJid entityBareJid;
        try {
            entityBareJid = JidCreate.entityBareFrom(conferenceId);
        }
        catch (Exception e) {
            throw new BadRequestExceptionWithMessage("Invalid conference ID");
        }
        EntityBareJid conferenceJid = entityBareJid;
        Intrinsics.checkNotNull(conferenceJid);
        JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference(conferenceJid);
        if (jitsiMeetConference == null) {
            throw new NotFoundExceptionWithMessage("Conference not found");
        }
        return jitsiMeetConference;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<JitsiMeetConference, Integer>> getConferences(Bridge $this$getConferences) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.conferenceStore.getAllConferences();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<JitsiMeetConference, Integer> pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            JitsiMeetConference conference = (JitsiMeetConference)element$iv$iv;
            boolean bl2 = false;
            ConferenceBridgeProperties conferenceBridgeProperties = conference.getBridges().get($this$getConferences);
            if (conferenceBridgeProperties != null) {
                int it = conferenceBridgeProperties.getParticipantCount();
                boolean bl3 = false;
                pair = new Pair<JitsiMeetConference, Integer>(conference, it);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<JitsiMeetConference, Integer> it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
    }
}

