/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.JNodeAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class JNodePopupListener
implements PopupMenuListener {
    private final CodeArea codeArea;
    private final List<JNodeAction> actions = new ArrayList<JNodeAction>();

    public JNodePopupListener(CodeArea codeArea) {
        this.codeArea = codeArea;
    }

    public void addActions(JNodeAction action) {
        this.actions.add(action);
    }

    private void updateNode(JNode node) {
        for (JNodeAction action : this.actions) {
            action.changeNode(node);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateNode(this.codeArea.getNodeUnderMouse());
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.updateNode(null);
    }
}

