/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaModuleSystem;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiConflictResolver;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.SmartList;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance(PsiResolveHelperImpl.class);
    private final PsiManager myManager;

    public PsiResolveHelperImpl(@NotNull Project project) {
        if (project == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(0);
        }
        this.myManager = PsiManager.getInstance(project);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public PsiResolveHelperImpl(@NotNull PsiManager manager) {
        if (manager == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
    }

    @Override
    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList2, PsiElement place) {
        JavaResolveResult[] result2;
        if (argumentList2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(2);
        }
        JavaResolveResult javaResolveResult = (result2 = this.multiResolveConstructor(classType, argumentList2, place)).length == 1 ? result2[0] : JavaResolveResult.EMPTY;
        if (javaResolveResult == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(3);
        }
        return javaResolveResult;
    }

    @Override
    public JavaResolveResult @NotNull [] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList2, @NotNull PsiElement place) {
        MethodResolverProcessor processor2;
        PsiClassType.ClassResolveResult classResolveResult;
        PsiClass aClass;
        if (type2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(4);
        }
        if (argumentList2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(6);
        }
        if ((aClass = (classResolveResult = type2.resolveGenerics()).getElement()) == null) {
            if (JavaResolveResult.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(7);
            }
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor2 = classResolveResult.getSubstitutor();
        if (argumentList2.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList2.getParent();
            processor2 = new MethodResolverProcessor(anonymous, argumentList2, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                if (JavaResolveResult.EMPTY_ARRAY == null) {
                    PsiResolveHelperImpl.$$$reportNull$$$0(8);
                }
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor2 = new MethodResolverProcessor(null, argumentList2, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, substitutor2);
        for (PsiMethod constructor2 : aClass.getConstructors()) {
            if (!processor2.execute(constructor2, state)) break;
        }
        JavaResolveResult[] javaResolveResultArray = processor2.getResult();
        if (javaResolveResultArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(9);
        }
        return javaResolveResultArray;
    }

    @Override
    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(10);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            PsiFile containingFile = ref.getContainingFile();
            LOG.assertTrue(containingFile.isValid(), referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(11);
        }
        return this.resolveVar(referenceText, context, null);
    }

    @Override
    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(12);
        }
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable2 = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable2;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context, boolean[] problemWithAccess) {
        if (referenceText == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(13);
        }
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        if (member2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(15);
        }
        return this.isAccessible(member2, member2.getModifierList(), place, accessObjectClass, null);
    }

    @Override
    public boolean isAccessible(@NotNull PsiMember member2, @Nullable PsiModifierList modifierList2, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        PsiClass containingClass;
        boolean accessible;
        if (member2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(17);
        }
        if ((accessible = JavaResolveUtil.isAccessible(member2, containingClass = member2.getContainingClass(), modifierList2, place, accessObjectClass, currentFileResolveScope)) && member2 instanceof PsiClass && !(member2 instanceof PsiTypeParameter)) {
            accessible = PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible((PsiClass)member2, place));
        }
        return accessible;
    }

    @Override
    public boolean isAccessible(@NotNull PsiPackage pkg, @NotNull PsiElement place) {
        if (pkg == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(18);
        }
        if (place == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(19);
        }
        return PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible(pkg.getQualifiedName(), null, place));
    }

    private static boolean isAccessible(Predicate<? super JavaModuleSystem> predicate) {
        return Stream.of(JavaModuleSystem.EP_NAME.getExtensions()).allMatch(predicate);
    }

    @Override
    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression expr, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        if (expr == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(20);
        }
        PsiFile containingFile = expr.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(expr, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, expr, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            if (CandidateInfo.EMPTY_ARRAY == null) {
                PsiResolveHelperImpl.$$$reportNull$$$0(21);
            }
            return CandidateInfo.EMPTY_ARRAY;
        }
        CandidateInfo[] candidateInfoArray = processor2.getCandidates();
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(22);
        }
        return candidateInfoArray;
    }

    @Override
    public boolean hasOverloads(@NotNull PsiCallExpression call2) {
        PsiJavaCodeReferenceElement classReference;
        if (call2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(23);
        }
        PsiFile containingFile = call2.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor(call2, containingFile, new PsiConflictResolver[0], new SmartList()){

            @Override
            protected boolean acceptVarargs() {
                return true;
            }
        };
        if (call2 instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)call2).getMethodExpression();
            processor2.setIsConstructor(false);
            processor2.setName(methodExpression.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor2, methodExpression, null);
        } else if (call2 instanceof PsiNewExpression && (classReference = ((PsiNewExpression)call2).getClassOrAnonymousClassReference()) != null) {
            processor2.setIsConstructor(true);
            processor2.setName(classReference.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor2, classReference, null);
        }
        return processor2.getCandidates().length > 1;
    }

    @Override
    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression call2, boolean dummyImplicitConstructor) {
        if (call2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(24);
        }
        CandidateInfo[] candidateInfoArray = this.getReferencedMethodCandidates(call2, dummyImplicitConstructor, false);
        if (candidateInfoArray == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(25);
        }
        return candidateInfoArray;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (typeParameter2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(26);
        }
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(27);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(28);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(29);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(30);
        }
        return this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2 != null ? parent2 : typeParameter2)).inferTypeForMethodTypeParameter(typeParameter2, parameters2, arguments2, partialSubstitutor, parent2, policy);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(31);
        }
        if (parent2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(32);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(33);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(34);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(35);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(36);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(PsiUtil.getLanguageLevel(parent2)).inferTypeArguments(typeParameters2, parameters2, arguments2, null, partialSubstitutor, parent2, policy, PsiUtil.getLanguageLevel(parent2));
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(37);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments2, @NotNull MethodCandidateInfo currentCandidate, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (currentCandidate == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(38);
        }
        if (parent2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(39);
        }
        if (policy == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(40);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(41);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(42);
        }
        if (parameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(43);
        }
        if (arguments2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(44);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, parameters2, arguments2, currentCandidate, currentCandidate.getSiteSubstitutor(), parent2, policy, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(45);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(46);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(47);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(48);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(49);
        }
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments(typeParameters2, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(50);
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters2, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        if (partialSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(51);
        }
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(52);
        }
        if (typeParameters2 == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(53);
        }
        if (leftTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(54);
        }
        if (rightTypes == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(55);
        }
        PsiSubstitutor psiSubstitutor = this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters2, leftTypes, rightTypes, partialSubstitutor, languageLevel);
        if (psiSubstitutor == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(56);
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @Override
    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile2) {
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile2);
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(57);
        }
        return languageLevel;
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PsiResolveHelperImpl.$$$reportNull$$$0(58);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return new PsiGraphInferenceHelper(this.myManager);
        }
        return new PsiOldInferenceHelper(this.myManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 56: 
            case 57: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 27: 
            case 31: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialSubstitutor";
                break;
            }
            case 28: 
            case 33: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 29: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 30: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: 
            case 42: 
            case 47: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCandidate";
                break;
            }
            case 41: 
            case 46: 
            case 52: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 48: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftTypes";
                break;
            }
            case 49: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/PsiResolveHelperImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveConstructor";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedMethodCandidates";
                break;
            }
            case 37: 
            case 45: 
            case 50: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeArguments";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveLanguageLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructor";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 56: 
            case 57: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveConstructor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedVariable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveAccessibleReferencedVariable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveVar";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 20: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedMethodCandidates";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "hasOverloads";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeForMethodTypeParameter";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeArguments";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getInferenceHelper";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 21: 
            case 22: 
            case 25: 
            case 37: 
            case 45: 
            case 50: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

