/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.List;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ResolvedGraphVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentDetailsSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasonSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolvedComponentVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.SelectedVariantSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ComponentResultSerializer {
    private final ComponentSelectionReasonSerializer reasonSerializer;
    private final ComponentDetailsSerializer componentDetailsSerializer;
    private final SelectedVariantSerializer selectedVariantSerializer;
    private final boolean returnAllVariants;

    public ComponentResultSerializer(ComponentDetailsSerializer componentDetailsSerializer, SelectedVariantSerializer selectedVariantSerializer, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, boolean returnAllVariants) {
        this.componentDetailsSerializer = componentDetailsSerializer;
        this.selectedVariantSerializer = selectedVariantSerializer;
        this.reasonSerializer = new ComponentSelectionReasonSerializer(componentSelectionDescriptorFactory);
        this.returnAllVariants = returnAllVariants;
    }

    public void readInto(Decoder decoder, ResolvedComponentVisitor builder) throws Exception {
        long resultId = decoder.readSmallLong();
        ComponentSelectionReason reason = this.reasonSerializer.read(decoder);
        String repo = decoder.readNullableString();
        builder.startVisitComponent(resultId, reason, repo);
        this.componentDetailsSerializer.readComponentDetails(decoder, builder);
        int variantCount = decoder.readSmallInt();
        for (int i = 0; i < variantCount; ++i) {
            this.selectedVariantSerializer.readSelectedVariant(decoder, builder);
        }
        builder.endVisitComponent();
    }

    public void write(Encoder encoder, ResolvedGraphComponent value) throws IOException {
        encoder.writeSmallLong(value.getResultId().longValue());
        this.reasonSerializer.write(encoder, value.getSelectionReason());
        encoder.writeNullableString((CharSequence)value.getRepositoryName());
        this.componentDetailsSerializer.writeComponentDetails(value.getResolveState(), this.returnAllVariants, encoder);
        List<ResolvedGraphVariant> selectedVariants = value.getSelectedVariants();
        encoder.writeSmallInt(selectedVariants.size());
        for (ResolvedGraphVariant variant : selectedVariants) {
            this.selectedVariantSerializer.writeVariantResult(variant, encoder);
        }
    }
}

