/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.VersionParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Version
implements Comparable<Version> {
    private Object[] parts;

    public Version(@Nonnull String v) {
        String[] rawParts = v.split("\\.");
        ArrayList<Object> parsedParts = new ArrayList<Object>();
        Pattern p = Pattern.compile("[0-9]+");
        for (int i = 0; i < rawParts.length; ++i) {
            Matcher m = p.matcher(rawParts[i]);
            if (m.matches()) {
                parsedParts.add(Integer.parseInt(rawParts[i]));
                continue;
            }
            if (i == rawParts.length - 1) {
                Pattern suffixPattern = Pattern.compile("([0-9]+)(.+)");
                Matcher suffixMatcher = suffixPattern.matcher(rawParts[i]);
                if (suffixMatcher.matches()) {
                    parsedParts.add(Integer.parseInt(suffixMatcher.group(1)));
                    parsedParts.add(suffixMatcher.group(2));
                    continue;
                }
                throw new VersionParseException("Bad version format \"" + v + "\"");
            }
            throw new VersionParseException("Bad version format \"" + v + "\"");
        }
        this.parts = parsedParts.toArray();
    }

    public Version(Version copyMe, int numPartsToCopy) {
        Object[] newVersionParts = new Object[numPartsToCopy];
        Object[] oldVersions = copyMe.getParts();
        for (int i = 0; i < numPartsToCopy; ++i) {
            newVersionParts[i] = oldVersions[i];
        }
        this.parts = newVersionParts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object part : this.parts) {
            if (!first && part instanceof Integer) {
                sb.append(".");
            }
            sb.append(part);
            first = false;
        }
        return sb.toString();
    }

    public Object[] getParts() {
        Object[] partsCopy = new Object[this.parts.length];
        for (int i = 0; i < this.parts.length; ++i) {
            partsCopy[i] = this.parts[i];
        }
        return partsCopy;
    }

    @Override
    public int compareTo(Version o) {
        for (int i = 0; i < this.parts.length && i < o.parts.length; ++i) {
            if (this.parts[i] instanceof Integer && o.parts[i] instanceof Integer) {
                int ov;
                int v = (Integer)this.parts[i];
                if (v > (ov = ((Integer)o.parts[i]).intValue())) {
                    return 1;
                }
                if (v >= ov) continue;
                return -1;
            }
            if (this.parts[i] instanceof String && o.parts[i] instanceof String) {
                String v = (String)this.parts[i];
                String ov = (String)o.parts[i];
                int diff = v.compareTo(ov);
                if (diff == 0) continue;
                return diff;
            }
            if (this.parts[i] instanceof Integer && o.parts[i] instanceof String) {
                return 1;
            }
            if (this.parts[i] instanceof String && o.parts[i] instanceof Integer) {
                return -1;
            }
            throw new IllegalStateException("Found a version part that's not a String or Integer");
        }
        if (this.parts.length == o.parts.length + 1 && this.parts[this.parts.length - 1] instanceof String) {
            return -1;
        }
        if (o.parts.length == this.parts.length + 1 && o.parts[o.parts.length - 1] instanceof String) {
            return 1;
        }
        if (this.parts.length > o.parts.length) {
            return 1;
        }
        if (this.parts.length < o.parts.length) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)obj) == 0;
    }

    public int hashCode() {
        int PRIME = 31;
        int hashCode = 0;
        for (Object part : this.parts) {
            hashCode += 31 * part.hashCode();
        }
        return hashCode;
    }
}

