/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractTableTargetedAction;
import ca.sqlpower.architect.swingui.action.EditColumnAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class InsertColumnAction
extends AbstractTableTargetedAction {
    private static final Logger logger = Logger.getLogger(InsertColumnAction.class);

    public InsertColumnAction(ArchitectFrame frame) {
        super(frame, Messages.getString("InsertColumnAction.name"), Messages.getString("InsertColumnAction.description"), "new_column");
        this.putValue("ActionCommandKey", "PlayPen");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 0));
        this.setEnabled(false);
    }

    @Override
    void processSQLObject(SQLObject so) throws SQLObjectException {
        SQLTable st = null;
        int idx = 0;
        if (so instanceof SQLTable) {
            logger.debug((Object)"user clicked on table, so we shall try to add a column to the end of the table.");
            st = (SQLTable)so;
            idx = st.getColumns().size();
            logger.debug((Object)("SQLTable click -- idx set to: " + idx));
        } else if (so instanceof SQLColumn) {
            logger.debug((Object)"trying to determine insertion index for table.");
            SQLColumn sc = (SQLColumn)so;
            st = sc.getParent();
            idx = st.getColumnIndex(sc);
            if (idx == -1) {
                throw new IllegalStateException("Selected column '" + sc.getName() + "' could not be found in parent table '" + st.getName() + "'");
            }
            ++idx;
        }
        if (st == null) {
            throw new NullPointerException("The SQLObject must be a instance of SQLTable or SQLColumn");
        }
        TablePane tp = (TablePane)this.getPlaypen().getSelectedItems().get(0);
        EditColumnAction editColumnAction = new EditColumnAction(this.getSession());
        editColumnAction.showDialog(st, idx, true, tp);
    }

    @Override
    void processTablePane(TablePane tp) throws SQLObjectException {
        int idx = tp.getSelectedItemIndex();
        if (idx < 0) {
            idx = ((SQLTable)tp.getModel()).getColumns().size();
        }
        EditColumnAction editColumnAction = new EditColumnAction(this.getSession());
        editColumnAction.showDialog((SQLTable)tp.getModel(), tp.getSelectedItemIndex() < 0 ? idx : idx + 1, true, tp);
    }

    @Override
    public void disableAction() {
        this.setEnabled(false);
        logger.debug((Object)"Disabling Insert Column Action");
        this.putValue("ShortDescription", Messages.getString("InsertColumnAction.shortDescription"));
    }
}

