/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;

public class Navigator
extends JDialog
implements SPListener,
PropertyChangeListener,
AdjustmentListener {
    private static final int SCALED_IMAGE_WIDTH = 200;
    private static final int SCALED_IMAGE_HEIGHT = 125;
    private final ArchitectFrame frame;
    private JPanel navigationPanel;
    private double scaleFactor;

    public Navigator(ArchitectFrame frame, Point location) {
        super((Frame)frame, Messages.getString("Navigator.name"));
        this.frame = frame;
        frame.addPropertyChangeListener(this);
        SQLPowerUtils.listenToHierarchy((SPObject)frame.getCurrentSession().getTargetDatabase(), (SPListener)this);
        this.getPlayPen().getContentPane().addComponentPropertyListener(this);
        JScrollPane playpenScrollPane = frame.getCurrentSession().getPlayPenScrollPane();
        playpenScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        playpenScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.navigationPanel = new JPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                block7: {
                    super.paintComponent(g);
                    double width = Math.max(Navigator.this.getPlayPen().getUsedArea().getWidth(), Navigator.this.getPlayPen().getViewportSize().getWidth());
                    double height = Math.max(Navigator.this.getPlayPen().getUsedArea().getHeight(), Navigator.this.getPlayPen().getViewportSize().getHeight());
                    Navigator.this.scaleFactor = Math.min(200.0 / width, 125.0 / height);
                    ((Graphics2D)g).scale(Navigator.this.scaleFactor, Navigator.this.scaleFactor);
                    RepaintManager currentManager = RepaintManager.currentManager(this);
                    try {
                        currentManager.setDoubleBufferingEnabled(false);
                        if (Navigator.this.getPlayPen().isRenderingAntialiased()) {
                            try {
                                Navigator.this.getPlayPen().setRenderingAntialiased(false);
                                Navigator.this.getPlayPen().paintComponent(g);
                                break block7;
                            }
                            finally {
                                Navigator.this.getPlayPen().setRenderingAntialiased(true);
                            }
                        }
                        Navigator.this.getPlayPen().paintComponent(g);
                    }
                    finally {
                        currentManager.setDoubleBufferingEnabled(true);
                    }
                }
                Rectangle view = Navigator.this.getPlayPen().getVisibleRect();
                g.setColor(Color.GREEN);
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.6f));
                g.drawRect(view.x, view.y, view.width, view.height - 5);
            }
        };
        this.navigationPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Navigator.this.adjustViewPort(e.getPoint());
            }
        });
        this.navigationPanel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Navigator.this.adjustViewPort(e.getPoint());
            }
        });
        this.navigationPanel.setPreferredSize(new Dimension(200, 125));
        this.getContentPane().add(this.navigationPanel);
        this.pack();
        location.translate(-this.getWidth(), 0);
        this.setLocation(location);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cleanup();
    }

    private Point getPointOnPlaypen(Point pointOnNavigator) {
        return new Point((int)((double)pointOnNavigator.x / this.scaleFactor), (int)((double)pointOnNavigator.y / this.scaleFactor));
    }

    private void adjustViewPort(Point pointOnNavigator) {
        Point pointOnPlaypen = this.getPointOnPlaypen(pointOnNavigator);
        Dimension viewSize = this.getPlayPen().getViewportSize();
        Dimension usedArea = this.getPlayPen().getUsedArea();
        pointOnPlaypen.translate(-viewSize.width / 2, -viewSize.height / 2);
        int x = pointOnPlaypen.x;
        int y = pointOnPlaypen.y;
        int xBoundary = Math.max(0, usedArea.width - viewSize.width);
        int yBoundary = Math.max(0, usedArea.height - viewSize.height);
        if (x < 0) {
            x = 0;
        } else if (x > xBoundary) {
            x = xBoundary;
        }
        if (y < 0) {
            y = 0;
        } else if (y > yBoundary) {
            y = yBoundary;
        }
        this.getPlayPen().setViewPosition(new Point(x, y));
        this.navigationPanel.repaint();
    }

    private PlayPen getPlayPen() {
        return this.frame.getCurrentSession().getPlayPen();
    }

    public void propertyChanged(PropertyChangeEvent evt) {
        this.navigationPanel.repaint();
    }

    public void childAdded(SPChildEvent e) {
        SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
    }

    public void childRemoved(SPChildEvent e) {
        SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
    }

    public void transactionStarted(TransactionEvent e) {
    }

    public void transactionEnded(TransactionEvent e) {
        this.navigationPanel.repaint();
    }

    public void transactionRollback(TransactionEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.navigationPanel.repaint();
    }

    public void cleanup() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.getPlayPen().getSession().getTargetDatabase(), (SPListener)this);
        this.getPlayPen().getContentPane().removeComponentPropertyListener(this);
        this.frame.removePropertyChangeListener(this);
        JScrollPane playpenScrollPane = this.frame.getCurrentSession().getPlayPenScrollPane();
        playpenScrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
        playpenScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("currentSession".equals(evt.getPropertyName())) {
            ArchitectSwingSession oldSession = (ArchitectSwingSession)evt.getOldValue();
            SQLPowerUtils.unlistenToHierarchy((SPObject)oldSession.getTargetDatabase(), (SPListener)this);
            oldSession.getPlayPen().getContentPane().removeComponentPropertyListener(this);
            JScrollPane oldScrollPane = oldSession.getPlayPenScrollPane();
            oldScrollPane.getVerticalScrollBar().removeAdjustmentListener(this);
            oldScrollPane.getHorizontalScrollBar().removeAdjustmentListener(this);
            SQLPowerUtils.listenToHierarchy((SPObject)this.frame.getCurrentSession().getTargetDatabase(), (SPListener)this);
            this.frame.getCurrentSession().getPlayPen().getContentPane().addComponentPropertyListener(this);
            JScrollPane newScrollPane = this.frame.getCurrentSession().getPlayPenScrollPane();
            newScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            newScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
            this.navigationPanel.repaint();
        }
    }
}

