#ifndef FL_FANCY_EDITOR_H
#define FL_FANCY_EDITOR_H 1

#if FL_MAJOR_VERSION == 1
#	include <FL/Fl_Editor.H>
#	include <FL/Fl_StatusPanel.H>
#else
#	include <fltk/Fl_Editor.h>
#	include <fltk/Fl_StatusPanel.h>
#endif

struct  fleditor_FindOptions
{
	wString SearchFor;
	wString ReplaceWith;
	bool MatchCase;
	bool MatchWord;
	bool SearchCursor;	// only one or the other of these two will be true.
	bool SearchDoc;
	bool PreserveCase;
	bool PromptReplace;
};

class Fl_FancyEditor : public Fl_Editor
{
protected:
	Fl_StatusPanel *lights;
	fleditor_FindOptions findopts;
	char PositionString[30];
protected:
	virtual FL_API Fl_Window *MakeFindDialog();
	virtual FL_API Fl_Window *MakeReplaceDialog();
public:
	FL_API Fl_FancyEditor(int x, int y, int w, int h, const char *cap="") ;
	virtual FL_API ~Fl_FancyEditor();
	FL_API int handle(int event);
	FL_API bool Find();
	FL_API bool Replace();
	FL_API bool FindNext();
	FL_API void ShowPanel(bool show);
	// everything below this is inline.
	bool ShowPanel() 	{ return (bool)lights->visible(); };
};

#endif //FL_FANCY_EDITOR_H
