/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.function.Supplier;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultJedisSocketFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.annots.Experimental;
import redis.clients.jedis.authentication.AuthXEventListener;
import redis.clients.jedis.authentication.AuthXManager;
import redis.clients.jedis.authentication.JedisAuthenticationException;
import redis.clients.jedis.csc.Cache;
import redis.clients.jedis.csc.CacheConnection;
import redis.clients.jedis.exceptions.JedisException;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;
    private final Cache clientSideCache;
    private final Supplier<Connection> objectMaker;
    private final AuthXEventListener authXEventListener;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this(hostAndPort, (JedisClientConfig)DefaultJedisClientConfig.builder().build(), null);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this(hostAndPort, clientConfig, null);
    }

    @Experimental
    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig, Cache csCache) {
        this(new DefaultJedisSocketFactory(hostAndPort, clientConfig), clientConfig, csCache);
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this(jedisSocketFactory, clientConfig, null);
    }

    private ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig, Cache csCache) {
        this.jedisSocketFactory = jedisSocketFactory;
        this.clientSideCache = csCache;
        this.clientConfig = clientConfig;
        AuthXManager authXManager = clientConfig.getAuthXManager();
        if (authXManager == null) {
            this.objectMaker = this.connectionSupplier();
            this.authXEventListener = AuthXEventListener.NOOP_LISTENER;
        } else {
            Supplier<Connection> supplier = this.connectionSupplier();
            this.objectMaker = () -> authXManager.addConnection((Connection)supplier.get());
            this.authXEventListener = authXManager.getListener();
            authXManager.start();
        }
    }

    private Supplier<Connection> connectionSupplier() {
        return this.clientSideCache == null ? () -> new Connection(this.jedisSocketFactory, this.clientConfig) : () -> new CacheConnection(this.jedisSocketFactory, this.clientConfig, this.clientSideCache);
    }

    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = (Connection)pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        try {
            Connection jedis = this.objectMaker.get();
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", (Throwable)je);
            throw je;
        }
    }

    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = (Connection)pooledConnection.getObject();
        this.reAuthenticate(jedis);
    }

    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = (Connection)pooledConnection.getObject();
        try {
            if (!jedis.isConnected()) {
                return false;
            }
            this.reAuthenticate(jedis);
            return jedis.ping();
        }
        catch (Exception e) {
            logger.warn("Error while validating pooled Connection object.", (Throwable)e);
            return false;
        }
    }

    private void reAuthenticate(Connection jedis) throws Exception {
        try {
            String result = jedis.reAuthenticate();
            if (result != null && !result.equals("OK")) {
                String msg = "Re-authentication failed with server response: " + result;
                JedisAuthenticationException failedAuth = new JedisAuthenticationException(msg);
                logger.error(failedAuth.getMessage(), (Throwable)failedAuth);
                this.authXEventListener.onConnectionAuthenticationError(failedAuth);
                return;
            }
        }
        catch (Exception e) {
            logger.error("Error while re-authenticating connection", (Throwable)e);
            this.authXEventListener.onConnectionAuthenticationError(e);
            throw e;
        }
    }
}

