/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.storage;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.traccar.model.BaseModel;
import org.traccar.model.Pair;
import org.traccar.model.Permission;
import org.traccar.model.Server;
import org.traccar.storage.Storage;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public class MemoryStorage
extends Storage {
    private final Map<Class<?>, Map<Long, Object>> objects = new HashMap();
    private final Map<Pair<Class<?>, Class<?>>, Set<Pair<Long, Long>>> permissions = new HashMap();
    private final AtomicLong increment = new AtomicLong();

    public MemoryStorage() {
        Server server = new Server();
        server.setId(1L);
        server.setRegistration(true);
        this.objects.put(Server.class, Map.of(server.getId(), server));
    }

    @Override
    public <T> List<T> getObjects(Class<T> clazz, Request request) {
        return this.objects.computeIfAbsent(clazz, key -> new HashMap()).values().stream().filter(object -> this.checkCondition(request.getCondition(), object)).map(object -> object).collect(Collectors.toList());
    }

    private boolean checkCondition(Condition genericCondition, Object object) {
        if (genericCondition == null) {
            return true;
        }
        if (genericCondition instanceof Condition.Compare) {
            Condition.Compare condition = (Condition.Compare)genericCondition;
            Object value = this.retrieveValue(object, condition.getVariable());
            int result = ((Comparable)value).compareTo(condition.getValue());
            return switch (condition.getOperator()) {
                case "<" -> {
                    if (result < 0) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (result <= 0) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (result > 0) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (result >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case "=" -> {
                    if (result == 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new RuntimeException("Unsupported comparison condition");
            };
        }
        if (genericCondition instanceof Condition.Between) {
            Condition.Between condition = (Condition.Between)genericCondition;
            Object fromValue = this.retrieveValue(object, condition.getFromVariable());
            int fromResult = ((Comparable)fromValue).compareTo(condition.getFromValue());
            Object toValue = this.retrieveValue(object, condition.getToVariable());
            int toResult = ((Comparable)toValue).compareTo(condition.getToValue());
            return fromResult >= 0 && toResult <= 0;
        }
        if (genericCondition instanceof Condition.Binary) {
            Condition.Binary condition = (Condition.Binary)genericCondition;
            if (condition.getOperator().equals("AND")) {
                return this.checkCondition(condition.getFirst(), object) && this.checkCondition(condition.getSecond(), object);
            }
            if (condition.getOperator().equals("OR")) {
                return this.checkCondition(condition.getFirst(), object) || this.checkCondition(condition.getSecond(), object);
            }
        } else {
            if (genericCondition instanceof Condition.Permission) {
                Condition.Permission condition = (Condition.Permission)genericCondition;
                long id = (Long)this.retrieveValue(object, "id");
                return this.getPermissionsSet(condition.getOwnerClass(), condition.getPropertyClass()).stream().anyMatch(pair -> {
                    if (condition.getOwnerId() > 0L) {
                        return ((Long)pair.first()).longValue() == condition.getOwnerId() && (Long)pair.second() == id;
                    }
                    return (Long)pair.first() == id && ((Long)pair.second()).longValue() == condition.getPropertyId();
                });
            }
            if (genericCondition instanceof Condition.LatestPositions) {
                return false;
            }
        }
        return false;
    }

    private Object retrieveValue(Object object, String key) {
        try {
            Method method = object.getClass().getMethod("get" + Character.toUpperCase(key.charAt(0)) + key.substring(1), new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> long addObject(T entity, Request request) {
        long id = this.increment.incrementAndGet();
        this.objects.computeIfAbsent(entity.getClass(), key -> new HashMap()).put(id, entity);
        return id;
    }

    @Override
    public <T> void updateObject(T entity, Request request) {
        Collection items;
        HashSet<String> columns = new HashSet<String>(request.getColumns().getColumns(entity.getClass(), "get"));
        if (request.getCondition() != null) {
            long id = (Long)((Condition.Equals)request.getCondition()).getValue();
            items = List.of(this.objects.computeIfAbsent(entity.getClass(), key -> new HashMap()).get(id));
        } else {
            items = this.objects.computeIfAbsent(entity.getClass(), key -> new HashMap()).values();
        }
        for (Method setter : entity.getClass().getMethods()) {
            if (!setter.getName().startsWith("set") || setter.getParameterCount() != 1 || !columns.contains(Introspector.decapitalize(setter.getName()))) continue;
            try {
                Method getter = entity.getClass().getMethod(setter.getName().replaceFirst("set", "get"), new Class[0]);
                Object value = getter.invoke(entity, new Object[0]);
                for (Object object : items) {
                    setter.invoke(object, value);
                }
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void removeObject(Class<?> clazz, Request request) {
        long id = (Long)((Condition.Equals)request.getCondition()).getValue();
        this.objects.computeIfAbsent(clazz, key -> new HashMap()).remove(id);
    }

    private Set<Pair<Long, Long>> getPermissionsSet(Class<?> ownerClass, Class<?> propertyClass) {
        return this.permissions.computeIfAbsent(new Pair(ownerClass, propertyClass), k -> new HashSet());
    }

    @Override
    public List<Permission> getPermissions(Class<? extends BaseModel> ownerClass, long ownerId, Class<? extends BaseModel> propertyClass, long propertyId) {
        return this.getPermissionsSet(ownerClass, propertyClass).stream().filter(pair -> ownerId == 0L || ((Long)pair.first()).equals(ownerId)).filter(pair -> propertyId == 0L || ((Long)pair.second()).equals(propertyId)).map(pair -> new Permission(ownerClass, (Long)pair.first(), propertyClass, (Long)pair.second())).collect(Collectors.toList());
    }

    @Override
    public void addPermission(Permission permission) {
        this.getPermissionsSet(permission.getOwnerClass(), permission.getPropertyClass()).add(new Pair<Long, Long>(permission.getOwnerId(), permission.getPropertyId()));
    }

    @Override
    public void removePermission(Permission permission) {
        this.getPermissionsSet(permission.getOwnerClass(), permission.getPropertyClass()).remove(new Pair<Long, Long>(permission.getOwnerId(), permission.getPropertyId()));
    }
}

