/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Xt013ProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("HI,d+").optional().text("TK,").number("(d+),").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").number("([+-]d+.d+),").number("([+-]d+.d+),").number("(d+),").number("(d+),").number("d+,").number("(d+),").expression("([FL]),").number("d+,").number("(d+),").number("x+,").number("x+,").number("(d+),").expression("[^,]*,").number("(d+.d+),").number("(d),").any().compile();

    public Xt013ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime());
        position.setLatitude(parser.nextDouble(0.0));
        position.setLongitude(parser.nextDouble(0.0));
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        position.setValid(parser.next().equals("F"));
        position.set("sat", parser.nextInt());
        position.set("rssi", parser.nextDouble());
        position.set("battery", parser.nextDouble(0.0));
        position.set("charge", parser.next().equals("1"));
        return position;
    }
}

