/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.google.inject.Injector;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Stream;
import org.traccar.config.Config;
import org.traccar.database.BufferingManager;
import org.traccar.database.NotificationManager;
import org.traccar.handler.BasePositionHandler;
import org.traccar.handler.ComputedAttributesHandler;
import org.traccar.handler.CopyAttributesHandler;
import org.traccar.handler.DatabaseHandler;
import org.traccar.handler.DistanceHandler;
import org.traccar.handler.DriverHandler;
import org.traccar.handler.EngineHoursHandler;
import org.traccar.handler.FilterHandler;
import org.traccar.handler.GeocoderHandler;
import org.traccar.handler.GeofenceHandler;
import org.traccar.handler.GeolocationHandler;
import org.traccar.handler.HemisphereHandler;
import org.traccar.handler.MotionHandler;
import org.traccar.handler.OutdatedHandler;
import org.traccar.handler.PositionForwardingHandler;
import org.traccar.handler.PostProcessHandler;
import org.traccar.handler.SpeedLimitHandler;
import org.traccar.handler.TimeHandler;
import org.traccar.handler.events.AlarmEventHandler;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.handler.events.BehaviorEventHandler;
import org.traccar.handler.events.CommandResultEventHandler;
import org.traccar.handler.events.DriverEventHandler;
import org.traccar.handler.events.FuelEventHandler;
import org.traccar.handler.events.GeofenceEventHandler;
import org.traccar.handler.events.IgnitionEventHandler;
import org.traccar.handler.events.MaintenanceEventHandler;
import org.traccar.handler.events.MediaEventHandler;
import org.traccar.handler.events.MotionEventHandler;
import org.traccar.handler.events.OverspeedEventHandler;
import org.traccar.handler.network.AcknowledgementHandler;
import org.traccar.helper.PositionLogger;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class ProcessingHandler
extends ChannelInboundHandlerAdapter
implements BufferingManager.Callback {
    private final CacheManager cacheManager;
    private final NotificationManager notificationManager;
    private final PositionLogger positionLogger;
    private final BufferingManager bufferingManager;
    private final List<BasePositionHandler> positionHandlers;
    private final List<BaseEventHandler> eventHandlers;
    private final PostProcessHandler postProcessHandler;
    private final Map<Long, Queue<Position>> queues = new HashMap<Long, Queue<Position>>();

    private synchronized Queue<Position> getQueue(long deviceId) {
        return this.queues.computeIfAbsent(deviceId, k -> new LinkedList());
    }

    @Inject
    public ProcessingHandler(Injector injector, Config config, CacheManager cacheManager, NotificationManager notificationManager, PositionLogger positionLogger) {
        this.cacheManager = cacheManager;
        this.notificationManager = notificationManager;
        this.positionLogger = positionLogger;
        this.bufferingManager = new BufferingManager(config, this);
        this.positionHandlers = Stream.of(ComputedAttributesHandler.Early.class, OutdatedHandler.class, TimeHandler.class, GeolocationHandler.class, HemisphereHandler.class, DistanceHandler.class, FilterHandler.class, GeofenceHandler.class, GeocoderHandler.class, SpeedLimitHandler.class, MotionHandler.class, ComputedAttributesHandler.Late.class, EngineHoursHandler.class, DriverHandler.class, CopyAttributesHandler.class, PositionForwardingHandler.class, DatabaseHandler.class).map(clazz -> (BasePositionHandler)injector.getInstance(clazz)).filter(Objects::nonNull).toList();
        this.eventHandlers = Stream.of(MediaEventHandler.class, CommandResultEventHandler.class, OverspeedEventHandler.class, BehaviorEventHandler.class, FuelEventHandler.class, MotionEventHandler.class, GeofenceEventHandler.class, AlarmEventHandler.class, IgnitionEventHandler.class, MaintenanceEventHandler.class, DriverEventHandler.class).map(clazz -> (BaseEventHandler)injector.getInstance(clazz)).filter(Objects::nonNull).toList();
        this.postProcessHandler = (PostProcessHandler)injector.getInstance(PostProcessHandler.class);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Position) {
            Position position = (Position)msg;
            this.bufferingManager.accept(ctx, position);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReleased(ChannelHandlerContext context, Position position) {
        boolean queued;
        Queue<Position> queue;
        Queue<Position> queue2 = queue = this.getQueue(position.getDeviceId());
        synchronized (queue2) {
            queued = !queue.isEmpty();
            queue.offer(position);
        }
        if (!queued) {
            try {
                this.cacheManager.addDevice(position.getDeviceId(), position.getDeviceId());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.processPositionHandlers(context, position);
        }
    }

    private void processPositionHandlers(final ChannelHandlerContext ctx, final Position position) {
        final Iterator<BasePositionHandler> iterator = this.positionHandlers.iterator();
        iterator.next().handlePosition(position, new BasePositionHandler.Callback(){

            @Override
            public void processed(boolean filtered) {
                Runnable continuation = () -> {
                    if (!filtered) {
                        if (iterator.hasNext()) {
                            ((BasePositionHandler)iterator.next()).handlePosition(position, this);
                        } else {
                            ProcessingHandler.this.processEventHandlers(ctx, position);
                        }
                    } else {
                        ProcessingHandler.this.finishedProcessing(ctx, position, true);
                    }
                };
                if (ctx.executor().inEventLoop()) {
                    continuation.run();
                } else {
                    ctx.executor().execute(continuation);
                }
            }
        });
    }

    private void processEventHandlers(ChannelHandlerContext ctx, Position position) {
        this.eventHandlers.forEach(handler -> handler.analyzePosition(position, event -> this.notificationManager.updateEvents(Map.of(event, position))));
        this.finishedProcessing(ctx, position, false);
    }

    private void finishedProcessing(ChannelHandlerContext ctx, Position position, boolean filtered) {
        if (!filtered) {
            this.postProcessHandler.handlePosition(position, ignore -> {
                this.positionLogger.log(ctx, position);
                ctx.writeAndFlush((Object)new AcknowledgementHandler.EventHandled(position));
                this.processNextPosition(ctx, position.getDeviceId());
            });
        } else {
            ctx.writeAndFlush((Object)new AcknowledgementHandler.EventHandled(position));
            this.processNextPosition(ctx, position.getDeviceId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextPosition(ChannelHandlerContext ctx, long deviceId) {
        Position nextPosition;
        Queue<Position> queue;
        Queue<Position> queue2 = queue = this.getQueue(deviceId);
        synchronized (queue2) {
            queue.poll();
            nextPosition = queue.peek();
        }
        if (nextPosition != null) {
            this.processPositionHandlers(ctx, nextPosition);
        } else {
            this.cacheManager.removeDevice(deviceId, deviceId);
        }
    }
}

