/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.Tls13KeySetType;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.record.cipher.RecordNullCipher;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResetConnectionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private Boolean asPlanned;

    public ResetConnectionAction() {
    }

    public ResetConnectionAction(String connectionAlias) {
        super(connectionAlias);
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        LOGGER.info("Terminating Connection");
        try {
            tlsContext.getTransportHandler().closeClientConnection();
        }
        catch (IOException ex) {
            LOGGER.debug("Could not close client connection", (Throwable)ex);
        }
        LOGGER.info("Resseting Cipher");
        tlsContext.getRecordLayer().setRecordCipher(new RecordNullCipher(tlsContext));
        tlsContext.getRecordLayer().updateDecryptionCipher();
        tlsContext.getRecordLayer().updateEncryptionCipher();
        LOGGER.info("Resetting SecureRenegotaiton");
        tlsContext.setLastClientVerifyData(new byte[0]);
        tlsContext.setLastServerVerifyData(new byte[0]);
        LOGGER.info("Resetting MessageDigest");
        tlsContext.getDigest().reset();
        LOGGER.info("Resetting ActiveKeySets");
        tlsContext.setActiveClientKeySetType(Tls13KeySetType.NONE);
        tlsContext.setActiveServerKeySetType(Tls13KeySetType.NONE);
        tlsContext.setReadSequenceNumber(0L);
        tlsContext.setWriteSequenceNumber(0L);
        LOGGER.info("Resetting DTLS numbers and cookie");
        tlsContext.setDtlsCookie(new byte[0]);
        tlsContext.setDtlsReadHandshakeMessageSequence(0);
        tlsContext.setDtlsWriteHandshakeMessageSequence(0);
        tlsContext.setDtlsReceiveEpoch(0);
        tlsContext.setDtlsWriteEpoch(0);
        LOGGER.info("Reopening Connection");
        try {
            tlsContext.getTransportHandler().initialize();
            this.asPlanned = true;
        }
        catch (IOException ex) {
            LOGGER.debug("Could not initialize TransportHandler", (Throwable)ex);
            this.asPlanned = false;
        }
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
        this.asPlanned = null;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted() && Objects.equals(this.asPlanned, Boolean.TRUE);
    }
}

