/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.awt.Image;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Action;
import org.netbeans.core.projects.FileStateEditor;
import org.netbeans.core.projects.FileStateManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.ToolsAction;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class SettingChildren
extends FilterNode.Children {
    public static final String PROP_LAYER_SESSION = "Session-Layer";
    public static final String PROP_LAYER_MODULES = "Modules-Layer";

    public SettingChildren(Node node) {
        super(node);
    }

    protected Node copyNode(Node node) {
        boolean bl = false;
        try {
            InstanceCookie.Of of;
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject != null && (of = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class)) != null && (of.instanceOf(Node.class) || of.instanceOf(Node.Handle.class))) {
                dataObject = null;
            }
            of = (DataFolder)node.getCookie(DataFolder.class);
            FileSystem fileSystem = dataObject == null || of != null ? null : dataObject.getPrimaryFile().getFileSystem();
            bl = fileSystem == null ? false : fileSystem.equals(Repository.getDefault().getDefaultFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return bl ? new SettingFilterNode(node) : (node.isLeaf() ? node.cloneNode() : new TrivialFilterNode(node));
    }

    private static Action[] removeActions(Action[] actionArray, Action[] actionArray2) {
        Action[] actionArray3 = actionArray;
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(actionArray));
        for (int i = 0; i < actionArray2.length; ++i) {
            Action action = actionArray2[i];
            if (!arrayList.contains(action)) continue;
            arrayList.remove(action);
            actionArray3 = arrayList.toArray(new Action[arrayList.size()]);
        }
        return actionArray3;
    }

    private static final class SettingFilterNode
    extends FilterNode {
        private FSL weakL = null;

        public SettingFilterNode(Node node) {
            super(node);
            this.disableDelegation(1536);
            FileObject fileObject = ((DataObject)this.getCookie(DataObject.class)).getPrimaryFile();
            this.weakL = new FSL(this);
            FileStateManager.getDefault().addFileStatusListener(this.weakL, fileObject);
            this.specialProp((Node.Property)new FileStateProperty(fileObject, 1, SettingChildren.PROP_LAYER_SESSION, false));
            this.specialProp((Node.Property)new FileStateProperty(fileObject, 2, SettingChildren.PROP_LAYER_MODULES, false));
        }

        public String getDisplayName() {
            DataShadow dataShadow;
            Node node;
            String string = null;
            DataObject dataObject = (DataObject)this.getCookie(DataObject.class);
            if (dataObject != null && dataObject instanceof DataShadow && (node = (dataShadow = (DataShadow)dataObject).getOriginal().getNodeDelegate()) != null) {
                string = node.getDisplayName();
            }
            return string != null ? string : super.getDisplayName();
        }

        private void specialProp(Node.Property property) {
            this.setValue(property.getName(), property);
        }

        public boolean equals(Object object) {
            return this == object || this.getOriginal().equals(object) || object != null && object.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }

        public Action[] getActions(boolean bl) {
            return SettingChildren.removeActions(super.getActions(bl), new Action[]{SystemAction.get(ToolsAction.class)});
        }

        private static class FSL
        implements FileStateManager.FileStatusListener {
            WeakReference<SettingFilterNode> node = null;

            public FSL(SettingFilterNode settingFilterNode) {
                this.node = new WeakReference<SettingFilterNode>(settingFilterNode);
            }

            public void fileStatusChanged(FileObject fileObject) {
                SettingFilterNode settingFilterNode = (SettingFilterNode)((Object)this.node.get());
                if (settingFilterNode == null) {
                    FileStateManager.getDefault().removeFileStatusListener(this, null);
                    return;
                }
                settingFilterNode.firePropertyChange(SettingChildren.PROP_LAYER_SESSION, null, null);
                settingFilterNode.firePropertyChange(SettingChildren.PROP_LAYER_MODULES, null, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileStateProperty
    extends PropertySupport<Integer> {
        static final int ACTION_DEFINE = 1;
        static final int ACTION_REVERT = 2;
        static final int ACTION_DELETE = 3;
        private FileObject primaryFile = null;
        private int layer;

        public FileStateProperty(String string) {
            this(null, 0, string, true);
        }

        public FileStateProperty(FileObject fileObject, int n, String string, boolean bl) {
            super(string, Integer.class, NbBundle.getMessage(FileStateProperty.class, (String)("LBL_FSP_" + string)), NbBundle.getMessage(FileStateProperty.class, (String)("LBL_FSP_Desc_" + string)), true, !bl);
            this.primaryFile = fileObject;
            this.layer = n;
            this.setValue("values", new Integer[]{0, 1, 2, 3});
            this.setValue("images", new Image[]{ImageUtilities.loadImage((String)"org/netbeans/core/resources/setting-defined.gif"), ImageUtilities.loadImage((String)"org/netbeans/core/resources/setting-ignored.gif"), ImageUtilities.loadImage((String)"org/netbeans/core/resources/setting-inherited.gif"), ImageUtilities.loadImage((String)"org/openide/resources/actions/empty.gif")});
        }

        public boolean canWrite() {
            if (!super.canWrite()) {
                return false;
            }
            Integer n = null;
            try {
                n = this.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return n != null && n != 0 && (this.layer != 2 || n != 3);
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return FileStateManager.getDefault().getFileState(this.primaryFile, this.layer);
        }

        public void setValue(Integer n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            FileStateManager fileStateManager = FileStateManager.getDefault();
            int n2 = n;
            try {
                switch (n2) {
                    case 1: 
                    case 2: {
                        boolean bl = true;
                        for (int i = 0; i < this.layer; ++i) {
                            int n3 = fileStateManager.getFileState(this.primaryFile, i);
                            if (n3 != 0) continue;
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SettingChildren.class, (String)"MSG_ask_remove_above_defined_files"), 0);
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (!object.equals(NotifyDescriptor.NO_OPTION)) break;
                            bl = false;
                            break;
                        }
                        if (bl) {
                            fileStateManager.define(this.primaryFile, this.layer, n2 == 2);
                        }
                        break;
                    }
                    case 3: {
                        fileStateManager.delete(this.primaryFile, this.layer);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Required file state change isn't allowed. Action=" + n2);
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return new FileStateEditor();
        }

        public String getShortDescription() {
            Integer n = null;
            String string = null;
            if (this.primaryFile != null) {
                try {
                    n = this.getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (n == null ? -1 : n) {
                    case 0: {
                        string = NbBundle.getMessage(SettingChildren.class, (String)"LBL_fstate_defined");
                        break;
                    }
                    case 1: {
                        string = NbBundle.getMessage(SettingChildren.class, (String)"LBL_fstate_ignored");
                        break;
                    }
                    case 2: {
                        string = NbBundle.getMessage(SettingChildren.class, (String)"LBL_fstate_inherited");
                        break;
                    }
                    case 3: {
                        string = NbBundle.getMessage(SettingChildren.class, (String)"LBL_fstate_undefined");
                    }
                }
            } else {
                string = super.getShortDescription();
            }
            return string == null || string.length() == 0 ? null : string;
        }
    }

    private static final class TrivialFilterNode
    extends FilterNode {
        public TrivialFilterNode(Node node) {
            super(node, (Children)new SettingChildren(node));
        }

        public boolean equals(Object object) {
            return this == object || this.getOriginal().equals(object) || object != null && object.equals(this.getOriginal());
        }

        public int hashCode() {
            return this.getOriginal().hashCode();
        }

        public Action[] getActions(boolean bl) {
            return SettingChildren.removeActions(super.getActions(bl), new Action[]{SystemAction.get(ToolsAction.class)});
        }

        public String getHtmlDisplayName() {
            return null;
        }
    }
}

