/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.filter;

import ca.odell.glazedlists.impl.filter.TextSearchStrategy;

public class SingleCharacterCaseInsensitiveTextSearchStrategy
implements TextSearchStrategy {
    private char subtextChar;
    private boolean subtextInitialized = false;
    private static final char[] UPPER_CASE_CACHE = new char[256];

    public void setSubtext(String subtext) {
        if (subtext == null) {
            throw new IllegalArgumentException("subtext may not be null");
        }
        if (subtext.length() != 1) {
            throw new IllegalArgumentException("subtext (" + subtext + ") must contain a single character");
        }
        this.subtextChar = SingleCharacterCaseInsensitiveTextSearchStrategy.toUpperCase(subtext.charAt(0));
        this.subtextInitialized = true;
    }

    public int indexOf(String text) {
        if (!this.subtextInitialized) {
            throw new IllegalStateException("setSubtext must be called with a valid value before this method can operate");
        }
        for (int c = 0; c < text.length(); ++c) {
            if (SingleCharacterCaseInsensitiveTextSearchStrategy.toUpperCase(text.charAt(c)) != this.subtextChar) continue;
            return c;
        }
        return -1;
    }

    private static char toUpperCase(char anyCase) {
        return anyCase < UPPER_CASE_CACHE.length ? UPPER_CASE_CACHE[anyCase] : Character.toUpperCase(anyCase);
    }

    static {
        for (char c = '\u0000'; c < UPPER_CASE_CACHE.length; c = (char)(c + '\u0001')) {
            SingleCharacterCaseInsensitiveTextSearchStrategy.UPPER_CASE_CACHE[c] = Character.toUpperCase(c);
        }
    }
}

