/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 / ivec4(-64, 72, 88, -76)) => ivec4(0, 0, 0, 0)
 * (12 / ivec4(64, 72, 88, 76)) => ivec4(0, 0, 0, 0)
 * (12 / ivec4(-24, 40, -23, 64)) => ivec4(0, 0, 0, 0)
 * (12 / ivec4(24, 40, 23, 64)) => ivec4(0, 0, 0, 0)
 * (-6 / ivec4(-64, 72, 88, -76)) => ivec4(0, 0, 0, 0)
 * (-6 / ivec4(64, 72, 88, 76)) => ivec4(0, 0, 0, 0)
 * (-6 / ivec4(-24, 40, -23, 64)) => ivec4(0, 0, 0, 0)
 * (-6 / ivec4(24, 40, 23, 64)) => ivec4(0, 0, 0, 0)
 * (76 / ivec4(-64, 72, 88, -76)) => ivec4(-1, 1, 0, -1)
 * (76 / ivec4(64, 72, 88, 76)) => ivec4(1, 1, 0, 1)
 * (76 / ivec4(-24, 40, -23, 64)) => ivec4(-3, 1, -3, 1)
 * (76 / ivec4(24, 40, 23, 64)) => ivec4(3, 1, 3, 1)
 * (-32 / ivec4(-64, 72, 88, -76)) => ivec4(0, 0, 0, 0)
 * (-32 / ivec4(64, 72, 88, 76)) => ivec4(0, 0, 0, 0)
 * (-32 / ivec4(-24, 40, -23, 64)) => ivec4(1, 0, 1, 0)
 * (-32 / ivec4(24, 40, 23, 64)) => ivec4(-1, 0, -1, 0)
 * (0 / ivec4(-64, 72, 88, -76)) => ivec4(0, 0, 0, 0)
 * (0 / ivec4(64, 72, 88, 76)) => ivec4(0, 0, 0, 0)
 * (0 / ivec4(-24, 40, -23, 64)) => ivec4(0, 0, 0, 0)
 * (0 / ivec4(24, 40, 23, 64)) => ivec4(0, 0, 0, 0)
 */
#version 120

void main()
{
  float[all(equal((12 / ivec4(-64, 72, 88, -76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array0;
  float[all(equal((12 / ivec4(64, 72, 88, 76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array1;
  float[all(equal((12 / ivec4(-24, 40, -23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array2;
  float[all(equal((12 / ivec4(24, 40, 23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array3;
  float[all(equal((-6 / ivec4(-64, 72, 88, -76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array4;
  float[all(equal((-6 / ivec4(64, 72, 88, 76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array5;
  float[all(equal((-6 / ivec4(-24, 40, -23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array6;
  float[all(equal((-6 / ivec4(24, 40, 23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array7;
  float[all(equal((76 / ivec4(-64, 72, 88, -76)), ivec4(-1, 1, 0, -1))) ? 1 : -1] array8;
  float[all(equal((76 / ivec4(64, 72, 88, 76)), ivec4(1, 1, 0, 1))) ? 1 : -1] array9;
  float[all(equal((76 / ivec4(-24, 40, -23, 64)), ivec4(-3, 1, -3, 1))) ? 1 : -1] array10;
  float[all(equal((76 / ivec4(24, 40, 23, 64)), ivec4(3, 1, 3, 1))) ? 1 : -1] array11;
  float[all(equal((-32 / ivec4(-64, 72, 88, -76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array12;
  float[all(equal((-32 / ivec4(64, 72, 88, 76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array13;
  float[all(equal((-32 / ivec4(-24, 40, -23, 64)), ivec4(1, 0, 1, 0))) ? 1 : -1] array14;
  float[all(equal((-32 / ivec4(24, 40, 23, 64)), ivec4(-1, 0, -1, 0))) ? 1 : -1] array15;
  float[all(equal((0 / ivec4(-64, 72, 88, -76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array16;
  float[all(equal((0 / ivec4(64, 72, 88, 76)), ivec4(0, 0, 0, 0))) ? 1 : -1] array17;
  float[all(equal((0 / ivec4(-24, 40, -23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array18;
  float[all(equal((0 / ivec4(24, 40, 23, 64)), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
