/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.auth.internal;

import java.security.Principal;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.auth.Authentication;
import org.openhab.core.auth.User;
import org.openhab.core.io.rest.auth.internal.AuthenticationSecurityContext;

@NonNullByDefault
public class UserSecurityContext
implements AuthenticationSecurityContext {
    private User user;
    private Authentication authentication;
    private String authenticationScheme;

    public UserSecurityContext(User user, Authentication authentication, String authenticationScheme) {
        this.user = user;
        this.authentication = authentication;
        this.authenticationScheme = authenticationScheme;
    }

    public Principal getUserPrincipal() {
        return this.user;
    }

    public boolean isUserInRole(@Nullable String role) {
        return this.user.getRoles().contains(role);
    }

    public boolean isSecure() {
        return true;
    }

    public String getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    @Override
    public Authentication getAuthentication() {
        return this.authentication;
    }
}

