/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class SessionsTreeModel
implements TreeModel {
    private Listener listener;
    private Vector listeners = new Vector();

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            Session[] ss = DebuggerManager.getDebuggerManager().getSessions();
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            to = Math.min(ss.length, to);
            from = Math.min(ss.length, from);
            Object[] fss = new Session[to - from];
            System.arraycopy(ss, from, fss, 0, to - from);
            return fss;
        }
        throw new UnknownTypeException(parent);
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            if (this.listener == null) {
                this.listener = new Listener(this);
            }
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof Session) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private WeakReference model;

        public Listener(SessionsTreeModel tm) {
            this.model = new WeakReference<SessionsTreeModel>(tm);
            DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)this);
        }

        private SessionsTreeModel getModel() {
            SessionsTreeModel m = (SessionsTreeModel)this.model.get();
            if (m == null) {
                DebuggerManager.getDebuggerManager().removeDebuggerListener("sessions", (DebuggerManagerListener)this);
            }
            return m;
        }

        public void sessionAdded(Session s) {
            SessionsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            m.fireTreeChanged();
        }

        public void sessionRemoved(Session s) {
            SessionsTreeModel m = this.getModel();
            if (m == null) {
                return;
            }
            m.fireTreeChanged();
        }
    }
}

