/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.suite.SuiteBrandingSupport;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SuiteBrandingModel
extends BrandingModel {
    public static final String NAME_PROPERTY = "app.name";
    public static final String TITLE_PROPERTY = "app.title";
    public static final String ICON_LOCATION_PROPERTY = "app.icon";
    public static final String BRANDING_TOKEN_PROPERTY = "branding.token";
    public static final String BRANDING_DIR_PROPERTY = "branding.dir";
    @NonNull
    private final SuiteProperties suiteProps;
    private boolean brandingChanged = false;

    public SuiteBrandingModel(@NonNull SuiteProperties suiteProps) {
        assert (null != suiteProps);
        this.suiteProps = suiteProps;
        this.locale = Locale.getDefault();
    }

    public void init() {
        super.init();
        this.brandingChanged = false;
    }

    public void setBrandingEnabled(boolean brandingEnabled) {
        if (this.isBrandingEnabled() != brandingEnabled) {
            this.brandingChanged = true;
        }
        super.setBrandingEnabled(brandingEnabled);
    }

    protected boolean isBrandingEnabledRefresh() {
        return this.suiteProps.getPlatformProperty(BRANDING_TOKEN_PROPERTY) != null || this.suiteProps.getProperty(BRANDING_TOKEN_PROPERTY) != null;
    }

    public void setName(String name) {
        super.setName(name);
        if (this.isBrandingEnabled()) {
            this.suiteProps.setProperty(NAME_PROPERTY, "${branding.token}");
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.setPlatformProperty(BRANDING_TOKEN_PROPERTY, this.getName());
        }
    }

    protected String getSimpleName() {
        Element nameEl = XMLUtil.findElement((Element)this.suiteProps.getProject().getHelper().getPrimaryConfigurationData(true), (String)"name", (String)"http://www.netbeans.org/ns/nb-module-suite-project/1");
        String text = nameEl != null ? XMLUtil.findText((Node)nameEl) : null;
        return text != null ? text : "???";
    }

    protected String loadName() {
        String bt = this.suiteProps.getPlatformProperty(BRANDING_TOKEN_PROPERTY);
        return bt != null ? bt : this.suiteProps.getProperty(NAME_PROPERTY);
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.isBrandingEnabled()) {
            this.suiteProps.setProperty(TITLE_PROPERTY, this.getTitle());
        }
    }

    protected String loadTitle() {
        return this.suiteProps.getProperty(TITLE_PROPERTY);
    }

    public void setIconSource(int size, URL url) {
        super.setIconSource(size, url);
        if (this.isBrandingEnabled()) {
            this.suiteProps.setProperty(ICON_LOCATION_PROPERTY, this.getIconLocation());
        }
    }

    public Project getProject() {
        return this.suiteProps.getProject();
    }

    protected File getProjectDirectoryFile() {
        return this.suiteProps.getProjectDirectoryFile();
    }

    public void store() throws IOException {
        super.store();
        if (!this.isBrandingEnabled() && this.brandingChanged) {
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.setPlatformProperty(BRANDING_TOKEN_PROPERTY, null);
            this.suiteProps.removeProperty(NAME_PROPERTY);
            this.suiteProps.removeProperty(TITLE_PROPERTY);
            this.suiteProps.removeProperty(ICON_LOCATION_PROPERTY);
        }
    }

    public void doSave() {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    SuiteBrandingModel.this.suiteProps.storeProperties();
                    return null;
                }
            });
        }
        catch (MutexException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    protected BrandingSupport createBranding() throws IOException {
        SuiteProject suiteProject = this.suiteProps.getProject();
        String brandingPath = suiteProject.getEvaluator().getProperty(BRANDING_DIR_PROPERTY);
        if (brandingPath == null) {
            brandingPath = "branding";
        }
        return new SuiteBrandingSupport(suiteProject, brandingPath, this.locale);
    }

    public void reloadProperties() {
        this.suiteProps.reloadProperties();
    }

    public void updateProjectInternationalizationLocales() {
        EditableProperties p = null;
        File projectProperties = null;
        try {
            projectProperties = new File(FileUtil.toFile((FileObject)this.suiteProps.getProject().getProjectDirectory()), "nbproject" + File.separatorChar + "project.properties");
            p = SuiteBrandingModel.getEditableProperties(projectProperties);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (p != null && projectProperties != null) {
            if (p.getProperty("branding.locales") == null) {
                p.setProperty("branding.locales", this.locale.toString());
            } else {
                String localizationsStr = p.getProperty("branding.locales");
                StringTokenizer tokenizer = new StringTokenizer(localizationsStr, ",");
                boolean containsLocale = false;
                while (tokenizer.hasMoreElements()) {
                    if (!this.locale.toString().equals(tokenizer.nextToken())) continue;
                    containsLocale = true;
                    break;
                }
                if (!containsLocale) {
                    p.setProperty("branding.locales", p.getProperty("branding.locales") + "," + this.locale.toString());
                }
            }
            try {
                SuiteBrandingModel.storeEditableProperties(p, projectProperties);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static EditableProperties getEditableProperties(File bundle) throws IOException {
        EditableProperties p = new EditableProperties(true);
        try (FileInputStream is = new FileInputStream(bundle);){
            p.load((InputStream)is);
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeEditableProperties(EditableProperties p, File bundle) throws IOException {
        FileObject fo = FileUtil.toFileObject((File)bundle);
        try (OutputStream os = null == fo ? new FileOutputStream(bundle) : fo.getOutputStream();){
            p.store(os);
        }
    }
}

