/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.api.request;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;

public abstract class Field {
    private final String fieldName;

    private Field(String fieldName) {
        this.fieldName = Objects.requireNonNull(fieldName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public abstract Object getFieldValue(Map<Field, Object> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field fieldName1 = (Field)o;
        return Objects.equals(this.getFieldName(), fieldName1.getFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.getFieldName());
    }

    public String toString() {
        return this.fieldName;
    }

    public static class InstantField
    extends Field {
        public InstantField(String fieldName) {
            super(fieldName);
        }

        @Override
        public Instant getFieldValue(Map<Field, Object> record) {
            return (Instant)record.get(this);
        }
    }

    public static class BooleanField
    extends Field {
        public BooleanField(String fieldName) {
            super(fieldName);
        }

        @Override
        public Boolean getFieldValue(Map<Field, Object> record) {
            return (Boolean)record.get(this);
        }
    }

    public static class NumberField
    extends Field {
        public NumberField(String fieldName) {
            super(fieldName);
        }

        @Override
        public Number getFieldValue(Map<Field, Object> record) {
            return (Number)record.get(this);
        }
    }

    public static class StringField
    extends Field {
        public StringField(String fieldName) {
            super(fieldName);
        }

        @Override
        public String getFieldValue(Map<Field, Object> record) {
            return (String)record.get(this);
        }
    }
}

