/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml.langattributes;

import nu.validator.xml.AttributesImpl;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlLangAttributeDroppingContentHandlerWrapper
implements ContentHandler {
    private final ContentHandler delegate;
    private final ErrorHandler errorHandler;
    private Locator locator = null;

    public XmlLangAttributeDroppingContentHandlerWrapper(ContentHandler delegate, ErrorHandler errorHandler) {
        this.delegate = delegate;
        this.errorHandler = errorHandler;
    }

    @Override
    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.characters(arg0, arg1, arg2);
    }

    @Override
    public void endDocument() throws SAXException {
        this.delegate.endDocument();
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        this.delegate.endElement(arg0, arg1, arg2);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.delegate.endPrefixMapping(arg0);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.delegate.ignorableWhitespace(arg0, arg1, arg2);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.delegate.processingInstruction(arg0, arg1);
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
        this.locator = arg0;
        this.delegate.setDocumentLocator(arg0);
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.delegate.skippedEntity(arg0);
    }

    @Override
    public void startDocument() throws SAXException {
        this.delegate.startDocument();
    }

    @Override
    public void startElement(String ns, String arg1, String arg2, Attributes attributes) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == ns) {
            this.delegate.startElement(ns, arg1, arg2, this.filterAttributes(attributes));
        } else {
            this.delegate.startElement(ns, arg1, arg2, attributes);
        }
    }

    private static boolean equalsIgnoreAsciiCase(String one, String other) {
        if (other == null) {
            return one == null;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            char c0 = one.charAt(i);
            char c1 = other.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private Attributes filterAttributes(Attributes attributes) throws SAXException {
        int len = attributes.getLength();
        String langValue = null;
        for (int i = 0; i < len; ++i) {
            String local = attributes.getLocalName(i);
            String uri = attributes.getURI(i);
            if (local == "lang" && uri == "http://www.w3.org/XML/1998/namespace") {
                langValue = attributes.getValue(i);
                continue;
            }
            if (local != "xml:lang" || uri != "") continue;
            String xmlLangValue = attributes.getValue(i);
            AttributesImpl attributesImpl = new AttributesImpl();
            for (int j = 0; j < i; ++j) {
                attributesImpl.addAttribute(attributes.getURI(j), attributes.getLocalName(j), attributes.getQName(j), attributes.getType(j), attributes.getValue(j));
            }
            for (int k = i + 1; k < len; ++k) {
                uri = attributes.getURI(k);
                local = attributes.getLocalName(k);
                if (local == "lang" && uri == "http://www.w3.org/XML/1998/namespace") {
                    langValue = attributes.getValue(k);
                }
                attributesImpl.addAttribute(uri, local, attributes.getQName(k), attributes.getType(k), attributes.getValue(k));
            }
            if (this.errorHandler != null && !XmlLangAttributeDroppingContentHandlerWrapper.equalsIgnoreAsciiCase(xmlLangValue, langValue)) {
                this.errorHandler.error(new SAXParseException("When the attribute \u201cxml:lang\u201d in no namespace is specified, the element must also have the attribute \u201clang\u201d present with the same value.", this.locator));
            }
            return attributesImpl;
        }
        return attributes;
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.delegate.startPrefixMapping(arg0, arg1);
    }
}

