/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.PHPElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.impl.AssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

abstract class ModelElementImpl
extends PHPElement
implements ModelElement {
    public static final int ANY_ATTR = -1;
    private PhpElementKind kind;
    private String name;
    private OffsetRange offsetRange;
    private Union2<String, FileObject> file;
    private PhpModifiers modifiers;
    private Scope inScope;
    protected ElementHandle indexedElement;
    private final String filenameUrl;
    private final boolean isDeprecated;

    ModelElementImpl(Scope inScope, ASTNodeInfo info, PhpModifiers modifiers, boolean isDeprecated) {
        this(inScope, info.getName(), inScope.getFile(), info.getRange(), info.getPhpElementKind(), modifiers, isDeprecated);
    }

    ModelElementImpl(Scope inScope, PhpElement element, PhpElementKind kind) {
        this(inScope, element.getName(), (Union2<String, FileObject>)Union2.createFirst((Object)element.getFilenameUrl()), new OffsetRange(element.getOffset(), element.getOffset() + element.getName().length()), kind, PhpModifiers.fromBitMask(element.getFlags()), element.isDeprecated());
        this.indexedElement = element;
    }

    ModelElementImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind, boolean isDeprecated) {
        this(inScope, name, file, offsetRange, kind, PhpModifiers.noModifiers(), isDeprecated);
    }

    ModelElementImpl(Scope inScope, String name, Union2<String, FileObject> file, OffsetRange offsetRange, PhpElementKind kind, PhpModifiers modifiers, boolean isDeprecated) {
        if (name == null || file == null || kind == null || modifiers == null) {
            throw new IllegalArgumentException("null for name | fo | kind: " + name + " | " + file + " | " + kind);
        }
        assert (file.hasFirst() || file.hasSecond());
        this.filenameUrl = file.hasFirst() && file.first() != null ? (String)file.first() : (file.hasSecond() && file.second() != null ? ((FileObject)file.second()).toURL().toExternalForm() : "");
        this.inScope = inScope;
        this.name = name;
        this.offsetRange = offsetRange;
        this.kind = kind;
        this.file = file;
        this.modifiers = modifiers;
        this.isDeprecated = isDeprecated;
        if (inScope instanceof ScopeImpl && !(this instanceof AssignmentImpl)) {
            ((ScopeImpl)inScope).addElement(this);
        }
    }

    @Override
    public final String getIn() {
        Scope retval = this.getInScope();
        return retval != null ? retval.getName() : null;
    }

    @Override
    public final Scope getInScope() {
        return this.inScope;
    }

    @Override
    @NonNull
    public final String getMimeType() {
        return super.getMimeType();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getNormalizedName() {
        String filePath = "";
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            filePath = fileObject.getPath();
        }
        return this.getNamespaceName().append(QualifiedName.create(this.getName())).toString().toLowerCase() + String.valueOf(this.offsetRange.getStart()) + filePath;
    }

    static boolean nameKindMatch(Pattern p, String text) {
        return p.matcher(text).matches();
    }

    static boolean nameKindMatchForVariable(String text, QuerySupport.Kind nameKind, String ... queries) {
        return ModelElementImpl.nameKindMatch(false, text, nameKind, queries);
    }

    static boolean nameKindMatch(String text, QuerySupport.Kind nameKind, String ... queries) {
        return ModelElementImpl.nameKindMatch(true, text, nameKind, queries);
    }

    private static boolean nameKindMatch(boolean forceCaseInsensitivity, String text, QuerySupport.Kind nameKind, String ... queries) {
        boolean result = false;
        block8: for (String query : queries) {
            switch (nameKind) {
                case CAMEL_CASE: {
                    if (!ModelUtils.toCamelCase(text).startsWith(query)) continue block8;
                    result = true;
                    continue block8;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    if (!text.toLowerCase().startsWith(query.toLowerCase())) continue block8;
                    result = true;
                    continue block8;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    text = text.toLowerCase();
                    result = ModelElementImpl.regexpMatch(text, query);
                    continue block8;
                }
                case REGEXP: {
                    result = ModelElementImpl.regexpMatch(text, query);
                    continue block8;
                }
                case EXACT: {
                    boolean retval;
                    boolean bl = retval = forceCaseInsensitivity ? text.equalsIgnoreCase(query) : text.equals(query);
                    if (!retval) continue block8;
                    result = true;
                    continue block8;
                }
                case PREFIX: {
                    if (!text.startsWith(query)) continue block8;
                    result = true;
                    continue block8;
                }
            }
        }
        return result;
    }

    private static boolean regexpMatch(String text, String query) {
        boolean result = false;
        Pattern p = Pattern.compile(query);
        if (ModelElementImpl.nameKindMatch(p, text)) {
            result = true;
        }
        return result;
    }

    @Override
    public final ElementKind getKind() {
        return this.getPhpElementKind().getElementKind();
    }

    @Override
    public PhpElementKind getPhpElementKind() {
        return this.kind;
    }

    @Override
    public int getOffset() {
        return this.getNameRange().getStart();
    }

    @Override
    public Union2<String, FileObject> getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @CheckForNull
    public FileObject getFileObject() {
        FileObject fileObject = null;
        Class<ModelElementImpl> clazz = ModelElementImpl.class;
        synchronized (ModelElementImpl.class) {
            String fileUrl;
            if (this.file != null) {
                fileObject = this.file.hasSecond() ? (FileObject)this.file.second() : null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (fileObject != null || !this.file.hasFirst() || !StringUtils.hasText((String)(fileUrl = (String)this.file.first()))) return fileObject;
            fileObject = PhpElementImpl.resolveFileObject(fileUrl);
            Class<ModelElementImpl> clazz2 = ModelElementImpl.class;
            synchronized (ModelElementImpl.class) {
                if (fileObject == null) return fileObject;
                this.file = Union2.createSecond((Object)fileObject);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return fileObject;
            }
        }
    }

    @Override
    public Set<Modifier> getModifiers() {
        assert (this.modifiers != null);
        EnumSet<Modifier> retval = EnumSet.noneOf(Modifier.class);
        if (this.modifiers.isPublic()) {
            retval.add(Modifier.PUBLIC);
        }
        if (this.modifiers.isProtected()) {
            retval.add(Modifier.PROTECTED);
        }
        if (this.modifiers.isPrivate()) {
            retval.add(Modifier.PRIVATE);
        }
        if (this.modifiers.isStatic()) {
            retval.add(Modifier.STATIC);
        }
        return retval;
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return this.modifiers;
    }

    public final boolean isScope() {
        return this instanceof ScopeImpl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpElementKind().toString()).append(" ").append(this.getName());
        return sb.toString();
    }

    @Override
    public PHPElement getPHPElement() {
        return this;
    }

    @Override
    public OffsetRange getNameRange() {
        return this.offsetRange;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelElementImpl other = (ModelElementImpl)obj;
        if (this.kind != other.kind) {
            return false;
        }
        return this.getNormalizedName().equals(other.getNormalizedName());
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + (this.kind != null ? this.kind.hashCode() : 0);
        hash = 89 * hash + (this.getNormalizedName() != null ? this.getNormalizedName().hashCode() : 0);
        return hash;
    }

    @Override
    public OffsetRange getOffsetRange(ParserResult result) {
        return this.getNameRange();
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
    }

    @Override
    public QualifiedName getNamespaceName() {
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        if (namespaceScope != null) {
            return namespaceScope.getQualifiedName();
        }
        return QualifiedName.createForDefaultNamespaceName();
    }

    public final QualifiedName getFullyQualifiedName() {
        return QualifiedName.createFullyQualified(this.getName(), this.getNamespaceName().toString());
    }

    @Override
    public ElementQuery getElementQuery() {
        FileScope fileScope = ModelUtils.getFileScope(this);
        if (fileScope == null && this.getInScope() instanceof IndexScope) {
            return ((IndexScope)this.getInScope()).getIndex();
        }
        assert (fileScope != null) : this;
        assert (fileScope.getIndexScope() != null) : this;
        return fileScope.getIndexScope().getIndex();
    }

    @Override
    public String getFilenameUrl() {
        return this.filenameUrl;
    }

    @Override
    public int getFlags() {
        return this.getPhpModifiers().toFlags();
    }

    @Override
    public boolean isPlatform() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            try {
                return FileUtil.getConfigRoot().getFileSystem().equals(fo.getFileSystem());
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public ElementHandle getIndexedElement() {
        return this.indexedElement;
    }

    public final boolean isAliased() {
        return false;
    }
}

