/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.search.project.SearchInfoHelper;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

final class SearchScopeNodeSelection
extends SearchScopeDefinition
implements LookupListener {
    private static final String MULTI_SELECTION_ID = "org/netbeans/modules/search/project/resources/multi_selection.png";
    private static final Icon MULTI_SELECTION_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/search/project/resources/multi_selection.png", (boolean)false);
    private final Lookup.Result<Node> lookupResult;
    private LookupListener lookupListener;

    public SearchScopeNodeSelection() {
        Lookup lookup = Utilities.actionsGlobalContext();
        this.lookupResult = lookup.lookupResult(Node.class);
        this.lookupListener = (LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult);
        this.lookupResult.addLookupListener(this.lookupListener);
    }

    public String getTypeId() {
        return "node selection";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"SearchScopeNameSelectedNodes");
    }

    public String getAdditionalInfo() {
        Node[] nodes = this.getNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        return nodes.length == 1 ? nodes[0].getDisplayName() : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"SearchScopeSelectionAddInfo", (Object)nodes.length);
    }

    public boolean isApplicable() {
        return SearchScopeNodeSelection.checkIsApplicable(this.getNodes());
    }

    private Node[] getNodes() {
        Collection lookupAll = Utilities.actionsGlobalContext().lookupAll(Node.class);
        Node[] nodes = new Node[lookupAll.size()];
        int i = 0;
        Iterator iterator = lookupAll.iterator();
        while (iterator.hasNext()) {
            Node n;
            nodes[i] = n = (Node)iterator.next();
            ++i;
        }
        return nodes;
    }

    private static boolean checkIsApplicable(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return false;
        }
        for (Node node : nodes) {
            if (SearchScopeNodeSelection.canSearch(node)) continue;
            return false;
        }
        return true;
    }

    private static boolean canSearch(Node node) {
        SearchInfo si = SearchInfoHelper.getSearchInfoForNode(node);
        return si != null && si.canSearch();
    }

    public SearchInfo getSearchInfo() {
        return this.getSearchInfo(TopComponent.getRegistry().getActivatedNodes());
    }

    private SearchInfo getSearchInfo(Node[] nodes) {
        if (nodes == null || nodes.length == 0) {
            return SearchInfoUtils.createEmptySearchInfo();
        }
        if ((nodes = SearchScopeNodeSelection.normalizeNodes(nodes)).length == 1) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(nodes[0]);
            return searchInfo != null ? searchInfo : SearchInfoUtils.createEmptySearchInfo();
        }
        ArrayList<SearchInfo> searchInfos = new ArrayList<SearchInfo>(nodes.length);
        for (Node node : nodes) {
            SearchInfo searchInfo = SearchScopeNodeSelection.getSearchInfo(node);
            if (searchInfo == null) continue;
            searchInfos.add(searchInfo);
        }
        if (searchInfos.isEmpty()) {
            return SearchInfoUtils.createEmptySearchInfo();
        }
        int searchInfoCount = searchInfos.size();
        if (searchInfoCount == 1) {
            return (SearchInfo)searchInfos.get(0);
        }
        return SearchInfoUtils.createCompoundSearchInfo((SearchInfo[])searchInfos.toArray(new SearchInfo[searchInfoCount]));
    }

    private static SearchInfo getSearchInfo(Node node) {
        return SearchInfoHelper.getSearchInfoForNode(node);
    }

    private static Node[] normalizeNodes(Node[] nodes) {
        if (nodes.length < 2) {
            return nodes;
        }
        HashMap<Node, Boolean> badNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        HashMap<Node, Boolean> goodNodes = new HashMap<Node, Boolean>(2 * nodes.length, 0.75f);
        ArrayList<Node> path = new ArrayList<Node>(10);
        ArrayList<Node> result = new ArrayList<Node>(nodes.length);
        for (Node node : nodes) {
            badNodes.put(node, Boolean.FALSE);
        }
        for (Node node : nodes) {
            path.clear();
            boolean isBad = false;
            for (Node n = node.getParentNode(); n != null; n = n.getParentNode()) {
                if (badNodes.containsKey(n)) {
                    isBad = true;
                    break;
                }
                if (goodNodes.containsKey(n)) break;
                path.add(n);
            }
            if (isBad) {
                badNodes.put(node, Boolean.TRUE);
                for (Node n : path) {
                    badNodes.put(n, Boolean.TRUE);
                }
                continue;
            }
            for (Node n : path) {
                goodNodes.put(n, Boolean.TRUE);
            }
            result.add(node);
        }
        return result.toArray(new Node[0]);
    }

    public void clean() {
        if (this.lookupResult != null && this.lookupListener != null) {
            this.lookupResult.removeLookupListener(this.lookupListener);
        }
    }

    public int getPriority() {
        return 400;
    }

    public void resultChanged(LookupEvent ev) {
        this.notifyListeners();
    }

    public Icon getIcon() {
        Node[] nodes = this.getNodes();
        if (nodes.length > 1) {
            return MULTI_SELECTION_ICON;
        }
        if (nodes.length == 1 && nodes[0] != null) {
            Node n = nodes[0];
            Image image = n.getIcon(1);
            if (image != null) {
                return ImageUtilities.image2Icon((Image)image);
            }
            return null;
        }
        return null;
    }
}

