/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.vault;

import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import com.oracle.bmc.vault.Vaults;
import com.oracle.bmc.vault.model.SecretSummary;
import com.oracle.bmc.vault.model.SecretVersionSummary;
import com.oracle.bmc.vault.requests.ListSecretVersionsRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.responses.ListSecretVersionsResponse;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class VaultsPaginators {
    private final Vaults client;

    public VaultsPaginators(Vaults client) {
        this.client = client;
    }

    public Iterable<ListSecretVersionsResponse> listSecretVersionsResponseIterator(final ListSecretVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretVersionsRequest.Builder>(){

            @Override
            public ListSecretVersionsRequest.Builder get() {
                return ListSecretVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, String>(){

            @Override
            public String apply(ListSecretVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretVersionsRequest.Builder>, ListSecretVersionsRequest>(){

            @Override
            public ListSecretVersionsRequest apply(RequestBuilderAndToken<ListSecretVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretVersionsRequest, ListSecretVersionsResponse>(){

            @Override
            public ListSecretVersionsResponse apply(ListSecretVersionsRequest request) {
                return VaultsPaginators.this.client.listSecretVersions(request);
            }
        });
    }

    public Iterable<SecretVersionSummary> listSecretVersionsRecordIterator(final ListSecretVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretVersionsRequest.Builder>(){

            @Override
            public ListSecretVersionsRequest.Builder get() {
                return ListSecretVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, String>(){

            @Override
            public String apply(ListSecretVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretVersionsRequest.Builder>, ListSecretVersionsRequest>(){

            @Override
            public ListSecretVersionsRequest apply(RequestBuilderAndToken<ListSecretVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretVersionsRequest, ListSecretVersionsResponse>(){

            @Override
            public ListSecretVersionsResponse apply(ListSecretVersionsRequest request) {
                return VaultsPaginators.this.client.listSecretVersions(request);
            }
        }, (Function)new Function<ListSecretVersionsResponse, List<SecretVersionSummary>>(){

            @Override
            public List<SecretVersionSummary> apply(ListSecretVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSecretsResponse> listSecretsResponseIterator(final ListSecretsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSecretsRequest.Builder>(){

            @Override
            public ListSecretsRequest.Builder get() {
                return ListSecretsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretsResponse, String>(){

            @Override
            public String apply(ListSecretsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretsRequest.Builder>, ListSecretsRequest>(){

            @Override
            public ListSecretsRequest apply(RequestBuilderAndToken<ListSecretsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretsRequest, ListSecretsResponse>(){

            @Override
            public ListSecretsResponse apply(ListSecretsRequest request) {
                return VaultsPaginators.this.client.listSecrets(request);
            }
        });
    }

    public Iterable<SecretSummary> listSecretsRecordIterator(final ListSecretsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSecretsRequest.Builder>(){

            @Override
            public ListSecretsRequest.Builder get() {
                return ListSecretsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSecretsResponse, String>(){

            @Override
            public String apply(ListSecretsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSecretsRequest.Builder>, ListSecretsRequest>(){

            @Override
            public ListSecretsRequest apply(RequestBuilderAndToken<ListSecretsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListSecretsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSecretsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListSecretsRequest, ListSecretsResponse>(){

            @Override
            public ListSecretsResponse apply(ListSecretsRequest request) {
                return VaultsPaginators.this.client.listSecrets(request);
            }
        }, (Function)new Function<ListSecretsResponse, List<SecretSummary>>(){

            @Override
            public List<SecretSummary> apply(ListSecretsResponse response) {
                return response.getItems();
            }
        });
    }
}

