/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.groovy.refactoring.findusages.FindUsagesPlugin;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.netbeans.modules.groovy.refactoring.move.MoveFileRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.rename.RenameRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.utils.GroovyProjectUtil;
import org.netbeans.modules.groovy.refactoring.utils.IdentifiersUtil;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class GroovyRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        RenameRefactoring renameRefactoring;
        Lookup lookup = refactoring.getRefactoringSource();
        NonRecursiveFolder pkg = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        RefactoringElement element = (RefactoringElement)lookup.lookup(RefactoringElement.class);
        FileObject sourceFO = (FileObject)lookup.lookup(FileObject.class);
        if (element == null) {
            return null;
        }
        if (sourceFO == null) {
            if (pkg != null) {
                sourceFO = pkg.getFolder();
            } else if (element != null) {
                sourceFO = element.getFileObject();
            }
        }
        if (sourceFO == null || !GroovyProjectUtil.isInGroovyProject(sourceFO)) {
            return null;
        }
        if (refactoring instanceof WhereUsedQuery) {
            return new FindUsagesPlugin(sourceFO, element, refactoring);
        }
        if (refactoring instanceof RenameRefactoring && !IdentifiersUtil.isPackageRename(renameRefactoring = (RenameRefactoring)refactoring)) {
            return new RenameRefactoringPlugin(sourceFO, element, (AbstractRefactoring)renameRefactoring);
        }
        if (refactoring instanceof MoveRefactoring) {
            return new MoveFileRefactoringPlugin(sourceFO, element, refactoring);
        }
        return null;
    }
}

