/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DiffLineDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="baseLine")
    private final Integer baseLine;
    @JsonProperty(value="targetLine")
    private final Integer targetLine;
    @JsonProperty(value="lineContent")
    private final String lineContent;
    @JsonProperty(value="conflictMarker")
    private final ConflictMarker conflictMarker;

    @Deprecated
    @ConstructorProperties(value={"baseLine", "targetLine", "lineContent", "conflictMarker"})
    public DiffLineDetails(Integer baseLine, Integer targetLine, String lineContent, ConflictMarker conflictMarker) {
        this.baseLine = baseLine;
        this.targetLine = targetLine;
        this.lineContent = lineContent;
        this.conflictMarker = conflictMarker;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getBaseLine() {
        return this.baseLine;
    }

    public Integer getTargetLine() {
        return this.targetLine;
    }

    public String getLineContent() {
        return this.lineContent;
    }

    public ConflictMarker getConflictMarker() {
        return this.conflictMarker;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DiffLineDetails(");
        sb.append("super=").append(super.toString());
        sb.append("baseLine=").append(String.valueOf(this.baseLine));
        sb.append(", targetLine=").append(String.valueOf(this.targetLine));
        sb.append(", lineContent=").append(String.valueOf(this.lineContent));
        sb.append(", conflictMarker=").append(String.valueOf((Object)this.conflictMarker));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DiffLineDetails)) {
            return false;
        }
        DiffLineDetails other = (DiffLineDetails)((Object)o);
        return Objects.equals(this.baseLine, other.baseLine) && Objects.equals(this.targetLine, other.targetLine) && Objects.equals(this.lineContent, other.lineContent) && Objects.equals((Object)this.conflictMarker, (Object)other.conflictMarker) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.baseLine == null ? 43 : this.baseLine.hashCode());
        result = result * 59 + (this.targetLine == null ? 43 : this.targetLine.hashCode());
        result = result * 59 + (this.lineContent == null ? 43 : this.lineContent.hashCode());
        result = result * 59 + (this.conflictMarker == null ? 43 : this.conflictMarker.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ConflictMarker implements BmcEnum
    {
        Base("BASE"),
        Target("TARGET"),
        Marker("MARKER"),
        None("NONE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConflictMarker> map;

        private ConflictMarker(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConflictMarker create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConflictMarker', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConflictMarker.class);
            map = new HashMap<String, ConflictMarker>();
            for (ConflictMarker v : ConflictMarker.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="baseLine")
        private Integer baseLine;
        @JsonProperty(value="targetLine")
        private Integer targetLine;
        @JsonProperty(value="lineContent")
        private String lineContent;
        @JsonProperty(value="conflictMarker")
        private ConflictMarker conflictMarker;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder baseLine(Integer baseLine) {
            this.baseLine = baseLine;
            this.__explicitlySet__.add("baseLine");
            return this;
        }

        public Builder targetLine(Integer targetLine) {
            this.targetLine = targetLine;
            this.__explicitlySet__.add("targetLine");
            return this;
        }

        public Builder lineContent(String lineContent) {
            this.lineContent = lineContent;
            this.__explicitlySet__.add("lineContent");
            return this;
        }

        public Builder conflictMarker(ConflictMarker conflictMarker) {
            this.conflictMarker = conflictMarker;
            this.__explicitlySet__.add("conflictMarker");
            return this;
        }

        public DiffLineDetails build() {
            DiffLineDetails model = new DiffLineDetails(this.baseLine, this.targetLine, this.lineContent, this.conflictMarker);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DiffLineDetails model) {
            if (model.wasPropertyExplicitlySet("baseLine")) {
                this.baseLine(model.getBaseLine());
            }
            if (model.wasPropertyExplicitlySet("targetLine")) {
                this.targetLine(model.getTargetLine());
            }
            if (model.wasPropertyExplicitlySet("lineContent")) {
                this.lineContent(model.getLineContent());
            }
            if (model.wasPropertyExplicitlySet("conflictMarker")) {
                this.conflictMarker(model.getConflictMarker());
            }
            return this;
        }
    }
}

